package com.integ.common.system;

import com.integ.common.logging.AppLog;
import com.integpg.system.Watchdog;

public class ApplicationWatchdog implements Runnable {

//    private static final boolean REQUIRED_OS_VERSION = MinimumVersion.atLeast("ApplicationWatchdog", "1.3-b10.3");
    private Watchdog _watchdog = null;
    private Thread _thd;



    public ApplicationWatchdog(int watchdogAction) {
//        if (REQUIRED_OS_VERSION) {
        _watchdog = new Watchdog(Application.getAppInstanceName());
        _watchdog.setAction(watchdogAction);
//        }
    }



    public void start() {
        if (null != _watchdog && null == _thd) {
            _thd = new Thread(this);
            _thd.setName(this.getClass().getName() + ":" + Application.getAppName());
            _thd.setDaemon(true);
            _thd.start();
        }
    }



    public void run() {
        AppLog.vital("Activate " + _watchdog.getText() + " watchdog");
        _watchdog.activate(120000);
        long lastFedTime = System.currentTimeMillis();

        try {
            while (true) {
                _watchdog.refresh();
                long elapsed = System.currentTimeMillis() - lastFedTime;
                System.out.println("hit watchdog.  " + elapsed + " since last hit");
                lastFedTime = System.currentTimeMillis();
                Thread.sleep(60000);
            }
        } catch (InterruptedException ex) {
            ex.printStackTrace(System.err);
        }
    }



    @Override
    public void finalize() {
        AppLog.vital("Deactivate " + Application.getAppInstanceName() + " watchdog");
        _watchdog.deactivate();
    }
}

