package com.integ.common.net.protocols.modbus.functions;

import com.integpg.system.ArrayUtils;

public class WriteMultipleCoils extends ModbusPdu {

    public WriteMultipleCoils(int startingAddress, int quantityOfCoils, byte[] coils) {
        super(15);

        int byteCount = coils.length;
        byte[] data = new byte[byteCount + 5];
        ArrayUtils.setShort(data, 0, (short) startingAddress);
        ArrayUtils.setShort(data, 2, (short) quantityOfCoils);
        data[4] = (byte) byteCount;
        int pos = 5;
        for (int i = 0; i < coils.length; i++) {
            data[pos++] = coils[i];
        }
        super.setData(data);
    }
}

