package com.integ.common.net.protocols.modbus.functions;

import java.io.DataOutputStream;
import java.io.IOException;

public abstract class ModbusPdu {

    protected final int _functionCode;
    private byte[] _data = new byte[0];
    protected int _responseFunctionCode;
    protected byte[] _response = new byte[0];



    public ModbusPdu(int functionCode) {
        _functionCode = functionCode;
    }



    public int getFunctionCode() {
        return _functionCode;
    }



    public void setData(byte[] data) {
        _data = data;
    }



    public byte[] getData() {
        return _data;
    }



    public void setResponse(byte[] response) {
        _response = response;
    }



    public byte[] getResponse() {
        return _response;
    }



    public void pack(DataOutputStream dos) throws IOException {
        dos.writeByte((byte) _functionCode);
        dos.write(_data);
    }



    public boolean isError() {
        return (0 != (_response[0] & 0x80));
    }



    public String getError() {
        int errorCode = _response[1];
        switch (errorCode) {
            case 1:
                return "Illegal function call";
            case 2:
                return "Illegal data address";
            case 3:
                return "Illegal data value";
            default:
                return "Unknown error";
        }
    }
}

