package com.integ.janoslib.protocols.modbus.functions;

import java.io.DataOutputStream;
import java.io.IOException;

public class LoginRequest extends ModbusFunctionRequest {

    private final String _username;
    private final String _password;



    public LoginRequest(String username, String password) {
        super(100, new LoginResponse());
        _username = username;
        _password = password;
    }



    @Override
    public int getRequestLength() {
        return 5;
    }



    @Override
    public void write(DataOutputStream outputStream) throws IOException {
        super.write(outputStream);
        outputStream.write(_username.length());
        outputStream.writeBytes(_username);
        outputStream.write(_password.length());
        outputStream.writeBytes(_password);
    }

}

