package com.integ.common.net;

import java.util.ArrayList;
import java.util.EventObject;

public class TCPConnectionListenerNotifier {

    private final ArrayList<TcpConnectionListener> _connecitonListeners = new ArrayList<>();



    public void addConnectionListener(TcpConnectionListener listener) {
        _connecitonListeners.add(listener);
    }



    public void notifyConnectionAttempt(EventObject eventObject) {
        for (TcpConnectionListener listener : _connecitonListeners) {
            listener.connectionAttempt(eventObject);
        }

    }



    public void notifyBytesReceived(BytesReceivedEvent bytesReceivedEvent) {
        for (TcpConnectionListener listener : _connecitonListeners) {
            listener.bytesReceived(bytesReceivedEvent);
        }
    }



    public void notifyConnectionEstablished(EventObject eventObject) {
        for (TcpConnectionListener listener : _connecitonListeners) {
            listener.connectionEstablished(eventObject);
        }
    }



    public void notifyConnectionClosed(final EventObject eventObject) {
        for (TcpConnectionListener listener : _connecitonListeners) {
            listener.connectionClosed(eventObject);
        }
    }

}

