package com.integ.common.utils;

/**
 * A Utility class for dealing with Hex
 */
public class HexUtils {

    public static final char[] HexArray = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F' };
    public static final char[] LowerHexArray = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f' };



    public static String bytesToHex(byte[] bytes) {
        return bytesToHex(bytes, 0, bytes.length);
    }



    public static String bytesToHex(byte[] bytes, int offset, int len) {
        if (null == bytes) return "null";

        char[] hexChars = new char[len * 2];
        int v, i = 0;
        for (int j = offset; j < offset + len; j++) {
            v = bytes[j] & 0xFF;
            hexChars[i++] = HexArray[(v >> 4 & 0x0F)];
            hexChars[i++] = HexArray[v & 0x0F];
        }
        return new String(hexChars);
    }



    public static byte[] hexToBytes(String hexString, int offset, int len) {
        if (null == hexString) return new byte[0];

        byte[] bytes = new byte[len/2];
        int i = 0;
        for (int j = offset; j < len; j += 2) {
            char c = hexString.charAt(j);
            int n = 0;
            if ('0' <= c && '9' >= c) n = c - '0';
            else if ('A' <= c && 'F' >= c) n = c - 55;
            else if ('a' <= c && 'f' >= c) n = c - 87;
            else throw new RuntimeException("error parsing hex");
//            System.out.println(String.format("%s, %d", String.valueOf(c), n));

            int val = n << 4;

            c = hexString.charAt(j + 1);
            n = 0;
            if ('0' <= c && '9' >= c) n = c - '0';
            else if ('A' <= c && 'F' >= c) n = c - 55;
            else if ('a' <= c && 'f' >= c) n = c - 87;
            else throw new RuntimeException("error parsing hex");

            val += n;
//            System.out.println(String.format("%s, %d, %d", String.valueOf(c), n, val));

            bytes[i++] = (byte) val;
        }
        return bytes;
    }



    public static String hexDump(byte[] bytes) {
        return hexDump(bytes, 0, bytes.length);
    }



    public static String hexDump(byte[] bytes, int offset, int length) {
        StringBuilder sb = new StringBuilder((length / 16 + 1) * 83);

        char[] line = new char[81];
        line[0] = '0';
        line[1] = 'x';
        line[line.length - 2] = '\r';
        line[line.length - 1] = '\n';

        int endAddress = offset + length;
        for (int lineAddress = offset - (offset % 16); lineAddress < endAddress; lineAddress += 16) {
            int charPos = 2;
            line[charPos++] = LowerHexArray[(lineAddress >> 12 & 0x0F)];
            line[charPos++] = LowerHexArray[(lineAddress >> 8 & 0x0F)];
            line[charPos++] = LowerHexArray[(lineAddress >> 4 & 0x0F)];
            line[charPos++] = LowerHexArray[lineAddress & 0x0F];
            line[charPos++] = ' ';
            line[charPos++] = ' ';
            line[charPos++] = ' ';

            for (int linePos = 0; linePos < 16; linePos++) {
                int address = lineAddress + linePos;
                if (address < offset) {
                    line[charPos++] = ' ';
                    line[charPos++] = ' ';
                    line[charPos++] = ' ';
                } else if (address < endAddress) {
                    int c = bytes[address];
                    line[charPos++] = LowerHexArray[(c >> 4 & 0x0F)];
                    line[charPos++] = LowerHexArray[c & 0x0F];
                    line[charPos++] = ' ';
                } else {
                    line[charPos++] = ' ';
                    line[charPos++] = ' ';
                    line[charPos++] = ' ';
                }

                if (7 == linePos) {
                    // add 2 spaces between each group of 8 bytes
                    line[charPos++] = ' ';
                    line[charPos++] = ' ';
                }
            }
            // add 3 spaces between the second group of 8 bytes and the ASCII output
            line[charPos++] = ' ';
            line[charPos++] = ' ';
            line[charPos++] = ' ';

            for (int linePos = 0; linePos < 16; linePos++) {
                int address = lineAddress + linePos;

                if (address < offset) line[charPos++] = ' ';
                else if (address < endAddress) {
                    char c = (char) bytes[address];
                    if (0x20 > c || 0x80 <= c) line[charPos++] = '.';
                    else line[charPos++] = c;
                } else line[charPos++] = ' ';
                if (7 == linePos) line[charPos++] = ' ';
            }

            sb.append(line, 0, line.length);
        }

        return sb.toString();
    }



    public static long parseHexAsLong(String s) {
        if (s == null) return 0;
        int len = s.length();
        // get the address in two stages because some addresses can be too great for the parseLong method.
        long l = Long.parseLong(s.substring(0, len - 8), 16);
        l <<= 32;
        l += Long.parseLong(s.substring(len - 8), 16);
        return l;
    }
}

