package java.util;

import java.io.File;

/**
 *
 * @author Bruce
 */
public class Json {

    private int handle = 0;

    /**
     * Json
     */
    public Json() {}

    /** Creates the JSON object from the supplied string.
     *
     * @param json string containing the JSON text representation
     */
    public Json(String json) {}

    /** Initializes the JSON object for the JSON string stored in the referenced File.
     *
     * @param file File object specifying the initial content.
     */
    public Json(File file) {}

    @Override
    public String toString() {}

    /**
     * Obtain the value from a name/value pair.
     * 
     * @param name defines the key/name for the pair.
     * @return an Object appropriate for the value. Numbers are returned as strings.
     */
    public Object get(String name) {}

    /**
     * Obtain a <code>int</code> value from a name/value pair.
     * 
     * @param name defines the key/name for the pair.
     * @return a <code>int</code> value
     * @throws NumberFormatException if the value is not numeric or contains an illegal numeric character.
     */
    public int getInt(String name) throws NumberFormatException {}

    /**
     * Obtain a <code>long</code> value from a name/value pair.
     * 
     * @param name defines the key/name for the pair.
     * @return a <code>long</code> value
     * @throws NumberFormatException if the value is not numeric or contains an illegal numeric character.
     */
    public long getLong(String name) throws NumberFormatException {}

    /**
     * Obtain a <code>float</code> value from a name/value pair.
     * 
     * @param name defines the key/name for the pair.
     * @return a <code>float</code> value
     * @throws NumberFormatException if the value is not numeric or contains an illegal numeric character.
     */
    public float getFloat(String name) throws NumberFormatException {}

    /**
     * Obtain a <code>double</code> value from a name/value pair.
     * 
     * @param name defines the key/name for the pair.
     * @return a <code>double</code> value
     * @throws NumberFormatException if the value is not numeric or contains an illegal numeric character.
     */
    public double getDouble(String name) throws NumberFormatException {}

    /**
     * Obtain the <code>string</code> from a name/value pair.
     * 
     * @param name defines the key/name for the pair.
     * @return a <code>string</code> 
     */
    public String getString(String name) {}

    /**
     * Obtain the <code>boolean</code> from a name/value pair.
     * 
     * @param name defines the key/name for the pair.
     * @return a <code>string</code> 
     */
    public boolean getBoolean(String name) {}

    /**
     *
     * @param name ?
     * @param value ?
     */
    public void put(String name, Object value) {}

    /**
     *
     * @param name ?
     * @param i ?
     */
    public void put(String name, int i) {}

    /**
     *
     * @param name ?
     * @param i ?
     */
    public void put(String name, long i) {}

    /**
     *
     * @param name ?
     * @param v ?
     */
    public void put(String name, float v) {}

    /**
     *
     * @param name ?
     * @param v ?
     */
    public void put(String name, double v) {}

    /**
     *
     * @param name ?
     */
    public void remove(String name) {}

    /**
     * Returns an enumeration of the values in this Json object.
     *
     * @return  an enumeration of the values.
     */
    public synchronized Enumeration elements()
	{}

    /**
     * Returns an enumeration of the keys in this Json object
     *
     * @return an enumeration of the keys
     */
    public synchronized Enumeration keys()
	{}

    /**
     * Tests if the specified string is a key in this Json object. This is definitive. If
     *  you are just interested in whether or not there is a value for the key use <code>get()</code>
     *  and check for a <code>null</code> value. This is faster and would return <code>null</code> even 
     *  if the key existed but had a JSON_NULL value.
     *
     * @param key possible key
     * @return  <code>true</code> if and only if the specified string
     *          is a key in this Json object, as determined by the
     *          <tt>equals</tt> method; <code>false</code> otherwise.
     */
    public synchronized boolean containsKey(String key)
	{}

    /**
     * Tests if some key contains the specified value.
     *
     * @param value a value to search for
     * @return <code>true</code> if and only if some key maps to the
     *             <code>value</code> argument in this Json object as
     *             determined by the <tt>equals</tt> method;
     *             <code>false</code> otherwise.
     * @exception  NullPointerException  if the value is <code>null</code>
     */
    public synchronized boolean contains(Object value)
	{}
    
    /**
     * Provides a list of the keys or names for all name/value pairs in the Json object.
     * 
     * @return String[] containing name for each pair in the object.
     */
    public String[] keyarray()
    {}

    /**
     * Returns the number of names or keys in this Json object.
     *
     * @return  the number of keys
     */
    public int size()
	{}

    /**
     * Determines if the Json object has content.
     *
     * @return  <code>TRUE</code> if the object is empty.
     */
    public boolean isEmpty()
	{}

    /** Stores the JSON object in string form.
     *
     * @param filename specifying the destination
     */
    public void save(String filename)
    {}

    /** Stores the JSON object in string form.
     *
     * @param file File object specifying the destination
     */
    public void save(File file)
    {}

    @Override
    protected void finalize()
            throws Throwable
    {}
    
    private static native int jsonnew(String json);
    private static native int jsonfile(String name);
    private static native void jsondel(int hnd);
    private static native String jsontostr(int hnd);
    private static native Object jsonget(int hnd, String name);
    private static native Object jsonset(int hnd, String name, Object value);
    private static native void jsonremove(int hnd, String name);
    private static native void jsonsave(int hnd, String fname);
    private static native int jsoncnt(int hnd);
    private static native Object[] jsonarr(int hnd, boolean elems);
}
