
package java.io;


// Referenced classes of package java.io:
//			Reader, IOException, InputStream

/**
 * Reads data from a character stream. Characters are buffered. Provides for
 * reading lines terminated by a carriage return \r or a linefeed \n character
 * ignoring any trailing linefeed \n after a carriage return \r (\r\n termination).
 *
 */

public class BufferedReader extends Reader
{

	private char buffer[];
	private int bufcnt;
	private int bufpos;
	private int markpos;
	private int marklimit;
	private boolean skipLF;
    private boolean terminated;
	private Reader in;

    /**
     * Creates a buffered stream from the Reader class. Uses a default buffer size of 512
     * characters. 
     * 
     * @param reader Reader stream object?
     */
    public BufferedReader(Reader reader)
	{}

    /**
     * Creates a buffered stream from the Reader class. The buffer size is specified.
     * 
     * @param reader Reader stream object
     * @param bufsiz Desired buffer size?
     */
    public BufferedReader(Reader reader, int bufsiz)
	{}

    /**
     * Closes the stream
     * 
     * @throws IOException with any error
     */
    public void close()
		throws IOException
	{}

    /**
     * Marks a position in the buffered stream. A call to reset() will reposition the
     * buffer pointer to the current position. This provides for a lookahead mechanism where
     * characters may be read, the buffer reset() and the data made available to be 
     * read once more.
     * 
     * @param limit the maximum to be buffered following the mark
     * 
     * @throws IOException with possible error
     * 
     */
    public void mark(int limit)
		throws IOException
	{}

    /**
     * Indicates whether a stream supports the marking feature.
     * 
     * @return TRUE always as this class supports mark()
     */
    public boolean markSupported()
	{}

    /**
     * Reads a single character. If the readline() method had been previously used and 
     * terminated by a carriage return \r this will ignore any following linefeed \n.
     * 
     * @return the character as an integer or -1 if the end of the stream is reached
     * 
     * @throws IOException with error
     */
    public int read()
		throws IOException
	{}

    /**
     * Reads characters into part of a character array. If readLine() was previously used
     * and terminated by a carriage return \r any following linefeed \n will be ignored.
     * 
     * @param arr the character array to receive data
     * @param ofs position in the character array to be modified
     * @param len maximum number of character to read
     * @return count read or -1 if the end of the stream is reached
     * @throws IOException with errors
     */
    public int read(char arr[], int ofs, int len)
		throws IOException
	{}

    /** Returns the next line of text from the stream (blocking). This will return a partial line if
     * the stream runs dry.
     *
     * @return string with a line of text up to a CR, LF or CRLF termination.
     * @throws IOException if stream closed
     */
    public String readLine()
		throws IOException
	{}
    
    /**
     * Indicates if the last readLine() was terminated.
     * 
     * @return TRUE if the previous line save terminated
     * @since v1.5.1
     */
    public boolean terminated() {}

    /**
     * Indicates that there is data ready to be read.
     * 
     * @return TRUE if there is unread data in the stream
     * 
     * @throws IOException with any error
     */
    @Override
    public boolean ready()
		throws IOException
	{}

    /** Loads the buffer. This appends new data at the current position and
     * not at the end of the buffer. Note that bufcnt is reset to bufpos.
     * 
     * @throws IOException 
     */
	private void refillBuffer()
		throws IOException
	{}

    /**
     * Resets the buffer pointer. If mark() has been called then the buffer pointer is 
     * moved back to that position and subsequent data may be reread. 
     * 
     * @throws IOException if mark() has not been called
     */
    public void reset()
		throws IOException
	{}

    /**
     * Skips the specified number of characters in the stream (blocking). If readLine() had been previously
     * used and the line terminated with a carriage return \r then any following linefeed \n is
     * ignored and not counted.
     * 
     * @param len count of characters to skip
     * 
     * @return number of characters skipped.
     * 
     * @throws IOException with any error
     */
    public long skip(long len)
		throws IOException
	{}
}
