package com.integ.common.collections;

import java.io.IOException;

public class BlockingQueue<E> {

    // our data store
    private final CircularQueue<E> _queue = new CircularQueue(128);
    private String _name = "BLOCKING QUEUE";



    public void setName(String name) {
        _name = name;
    }



    public void put(E object) throws Exception {
        synchronized (_queue) {
            _queue.enqueue(object);
//            if (null != _log && 1 < _queue.size()) {
//            if (1 < _queue.size()) {
//                AppLog.warn(String.format("%s now has %d elements in blocking queue", _name, _queue.size()));
//            }

            // notify any threads currently waiting on the queue in the get command that there is new data
//            _log.info(" - notify consumer.");
            _queue.notifyAll();
        }
        // dump our timeslice
        Thread.sleep(1);
    }



    public E get() throws IOException {
        synchronized (_queue) {
            // if the queue is empty then we should wait on it for noe data.  this causes our get method to be 
            //  a blocking method.  we use a while here to make sure there are not any spurious wakeups where there 
            //  was not any data added
            while (0 == _queue.size()) {
                try {
//                    _log.info(" - block for data.");
                    _queue.wait();
                } catch (InterruptedException ex) {
                }
            }
//            _log.info(" - data available.");

            // there must be data in the queue.  get the data by removing it from the queue and return the data
            E object = _queue.dequeue();

//            if (null != _log && 0 < _queue.size()) {
//            if (0 < _queue.size()) {
//                AppLog.warn(String.format("%s has %d elements remaining in blocking queue", _name, _queue.size()));
//            }

            return object;
        }
    }



    public int size() {
        return _queue.size();
    }
}

