package com.integ.common.system;

import com.integpg.system.JANOS;

public class UnitConfig {

    public static final String MODEL = JANOS.getRegistryString("$Model", "");
    public static final int SERIAL_NUMBER = JANOS.getSerialNumber();
    public static final String VERSION = JANOS.getRegistryString("$Version", "");



    public static boolean is410() {
        return MODEL.equals("410");
    }



    public static boolean is412() {
        return MODEL.equals("412");
    }



    public static boolean is414() {
        return MODEL.equals("414");
    }



    public static boolean is412DMX() {
        return MODEL.equals("412DMX");
    }



    public static int getInputCount() {
        return (is412() || is412DMX()) ? 4 : (is414()) ? 12 : 8;
    }



    public static int getOutputCount() {
        return (is412() || is412DMX()) ? 12 : (is414()) ? 4 : 8;
    }



    public static String getHostname() {
        return JANOS.getRegistryString("IpConfig/Hostname", "jr" + JANOS.getSerialNumber());
    }



    // addeed 3.7
    public static String getIpAddress() {
        return JANOS.getRegistryString("ipconfig/ipaddress", "");
    }
}

