
package java.net;

import com.integpg.system.ArrayUtils;
import java.io.*;

// Referenced classes of package java.net:
//			SocketImpl, BindException, Inet6Address, InetAddress, 
//			SocketException, SocketInputStream, SocketOptions, SocketOutputStream, 
//			UnknownHostException

class PlainSocketImpl extends SocketImpl
{

	public static final String socksDefaultPortStr = "1080";
	public static final String socksPortProp = "socksProxyPort";
	public static final String socksServerProp = "socksProxyHost";

	PlainSocketImpl()
	{}

	protected synchronized void accept(SocketImpl socketimpl)
		throws IOException
	{}

    private static native int socketAccept(int sock);

    private static native int socketGetRemoteAddr(int sock);

    private static native int socketGetRemotePort(int sock);

    protected synchronized int available()
		throws IOException
	{}

	private static native int socketAvailable(int sock)
		throws SocketException;

	protected synchronized void bind(InetAddress inetaddress, int port)
		throws IOException
	{}

    private static native int socketBind(int sock, int addr, int port);

    private static native void socketSetRemote(int sock, int addr, int port);

	protected void close()
		throws IOException
	{}

    private static native void socketClose(int sock);

    protected void connect(String s, int i)
		throws UnknownHostException, IOException
	{}

	protected void connect(InetAddress inetaddress, int port)
		throws IOException
	{}

    private static native void socketConnect(int sock, int addr, int port);
    private static native int socketGetLocalPort(int sock);

    protected synchronized void create(boolean stream)
		throws IOException
	{}

    private static native int socketOpen(int port, int addr, boolean stream);

    protected void finalize()
		throws IOException
	{}

	protected synchronized InputStream getInputStream()
		throws IOException
	{}

	public Object getOption(int i)
		throws SocketException
	{}

	protected synchronized OutputStream getOutputStream()
		throws IOException
	{}

    @Override
	public int getSoTimeout()
		throws SocketException
	{}

    @Override
	public void setSoTimeout(int to)
		throws SocketException
	{}

    @Override
	public void setSecure(boolean negotiate)
		throws SocketException
	{}

    private static native int socketSecure(int sock, boolean nego);
    private static native int socketGetSoTimeout(int sock);
    private static native void socketSetSoTimeout(int sock, int timeout);
    
    public byte[] getCertificate() {}
    
    private static native byte[] socketCert(int sock);

	int getSoLinger()
		throws SocketException
	{}

	void setSoLinger(int to)
		throws SocketException
	{}

    private static native int socketGetSoLinger(int sock);

    private static native void socketSetSoLinger(int sock, int timeout);

	boolean getTcpNoDelay()
		throws SocketException
	{}

	void setTcpNoDelay(boolean flag)
		throws SocketException
	{}

    private static native boolean socketGetTcpNoDelay(int sock);

    private static native void socketSetTcpNoDelay(int sock, boolean flag);

	boolean getKeepAlive()
		throws SocketException
	{}

	void setKeepAlive(boolean flag)
		throws SocketException
	{}

    private static native boolean socketGetKeepAlive(int sock);

    private static native void socketSetKeepAlive(int sock, boolean flag);

	int getSocketId()
	{}

	private static native byte[] getsockoptNative(int i, int j, int k, byte abyte0[], byte abyte1[])
		throws SocketException;

	protected synchronized void listen(int nqueue)
		throws IOException
	{}

	public void setOption(int i, Object obj)
		throws SocketException
	{}

	private static native byte[] setsockoptNative(int i, int j, int k, byte abyte0[], int l)
		throws SocketException;

	private static native void socketListen(int sock, int nqueue)
		throws SocketException;

}
