package com.integ.common.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class DateUtils {

    public static final long MILLIS_IN_SECOND = 1000;
    public static final long MILLIS_IN_MINUTE = MILLIS_IN_SECOND * 60;
    public static final long MILLIS_IN_HOUR = MILLIS_IN_MINUTE * 60;
    public static final long MILLIS_IN_DAY = MILLIS_IN_HOUR * 24;

    private static final Calendar CALENDAR = Calendar.getInstance();
    private static final TimeZone TIME_ZONE = CALENDAR.getTimeZone();



    public static TimeZone getTimezone() {
        return TIME_ZONE;
    }



    /**
     * @since 5.0
     */
    public static long now() {
        return System.currentTimeMillis();
    }



    /**
     * added 1.12
     */
    public static String getTimezoneID() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("z");
        return dateFormat.format(new Date());
    }



    public static long getTimezoneOffset() {
        long timeZoneOffset = TIME_ZONE.getOffset(
                CALENDAR.get(Calendar.ERA),
                CALENDAR.get(Calendar.YEAR),
                CALENDAR.get(Calendar.MONTH),
                CALENDAR.get(Calendar.DATE),
                CALENDAR.get(Calendar.DAY_OF_WEEK),
                (int) getMillisIntoDay());
        return timeZoneOffset;
    }



    public static boolean isDaylightSavings() {
        return TIME_ZONE.inDaylightTime(CALENDAR.getTime());
    }



    /**
     * added 1.6
     */
    public static long getStartOfDay() {
        long now = System.currentTimeMillis();
        long startOfDay = now - (now % 1000) - getMillisIntoDay();
        return startOfDay;
    }



    /**
     * added 1.6
     */
    public static long getStartOfHour() {
        long startOfHour = System.currentTimeMillis() - System.currentTimeMillis() % MILLIS_IN_HOUR;
        return startOfHour;
    }



    /**
     * added 1.6
     */
    public static long getStartOfMinute() {
        long startOfMinute = System.currentTimeMillis() - System.currentTimeMillis() % MILLIS_IN_MINUTE;
        return startOfMinute;
    }



    /**
     * added 1.6
     */
    public static long getMillisIntoDay() {
        return getMillisIntoDay(System.currentTimeMillis());
    }



    /**
     * added 9
     */
    public static long getMillisIntoDay(long time) {
        CALENDAR.setTimeInMillis(time);
        long millisIntoDay = CALENDAR.get(Calendar.HOUR_OF_DAY) * 3600000
                + CALENDAR.get(Calendar.MINUTE) * 60000
                + CALENDAR.get(Calendar.SECOND) * 1000;
        return millisIntoDay;
    }



    public static long getTimeInDay(int hour, int minute, int second) {
        long timeInDay = DateUtils.MILLIS_IN_HOUR * hour
                + DateUtils.MILLIS_IN_MINUTE * minute
                + DateUtils.MILLIS_IN_SECOND * second;
        System.out.println("timeInDay: " + timeInDay);
        timeInDay = DateUtils.getStartOfDay() + timeInDay;
        System.out.println("timeInDay: " + timeInDay);
        return timeInDay;
    }



    /**
     *
     * @param _fromTimeOfDayString
     * @return
     * @since 5.1
     */
    public static long getTimeInDayFromString(String timeString) {
        String[] timeParts = StringUtils.split(timeString, ":");
        int hourOfDay = Integer.parseInt(timeParts[0]);
        int minutes = Integer.parseInt(timeParts[1]);
        int seconds = (2 < timeParts.length) ? Integer.parseInt(timeParts[2]) : 0;

        return (hourOfDay * 3600
                + minutes * 60
                + seconds) * 1000;
    }
}

