package com.integ.common.utils;

import java.io.PrintWriter;
import java.io.StringWriter;

public final class ExceptionUtils extends ThreadGroup {

    private static final StringWriter SW = new StringWriter(256);
    private static final PrintWriter PW = new PrintWriter(SW, false);



    public ExceptionUtils() {
        super("Exception Handler");
    }



    public void uncaughtException(Thread t, Throwable e) {
        System.err.println(t + " caused: " + getStackTrace(e));
    }



    public static String getStackTrace(Throwable ex) {
        synchronized (SW) {
            SW.getBuffer().setLength(0);
            ex.printStackTrace(PW);
            return SW.toString();
        }
    }

}

