package com.integ.common.iolog;

import com.integ.common.system.UnitConfig;
import com.integpg.system.IoEvent;
import com.integpg.system.JANOS;

public class DigitalOutputsIoLogMonitor extends IoLogMonitor {

    @Override
    public void alertIoChannelListeners(IoEvent ioEvent) {
        if (0 != _ioChannelLogEventListeners.size()) {
            for (int chan = 0; chan < UnitConfig.getOutputCount(); chan++) {
                if (1 == ((ioEvent.mask >> chan) & 1)) {
                    int state = (ioEvent.states >> chan) & 1;
//                    System.out.println("@" + QUICK_DATE_FORMAT.format(ioEvent.timestamp)
//                            + " channel " + (chan + 1)
//                            + " is now " + (1 == state ? "HIGH" : "LOW"));
                    System.out.println(String.format("@%s channel %d is now %s",
                            QUICK_DATE_FORMAT.format(ioEvent.timestamp), (chan + 1), (1 == state ? "HIGH" : "LOW")));

                    DigitalOutputChannelEvent digitalOutputEvent = new DigitalOutputChannelEvent();
                    digitalOutputEvent.Channel = (chan + 1);
                    digitalOutputEvent.TransitionTime = ioEvent.timestamp;
                    digitalOutputEvent.State = (1 == state);
                    digitalOutputEvent.UsageMeter = JANOS.getUsageMeter(chan + UnitConfig.getInputCount());

                    for (IoChannelLogListener ioChannelListener : _ioChannelLogEventListeners) {
                        ioChannelListener.onIoChannelEvent(digitalOutputEvent);
                    }
                }
            }
        }
    }



    @Override
    protected IoEvent[] getIoEvents() {
        return _iolog.getOutputEvents();
    }
}

