package com.integ.common.iolog;

import com.integ.common.system.UnitConfig;
import com.integpg.system.IoEvent;
import com.integpg.system.JANOS;

public class DigitalInputsIoLogMonitor extends IoLogMonitor {

    @Override
    public void alertIoChannelListeners(IoEvent ioEvent) {
        if (0 != _ioChannelLogEventListeners.size()) {
            for (int chan = 0; chan < UnitConfig.getInputCount(); chan++) {
                if (1 == ((ioEvent.mask >> chan) & 1)) {
                    int state = (ioEvent.states >> chan) & 1;
//                    System.out.println("@" + QUICK_DATE_FORMAT.format(ioEvent.timestamp)
//                            + " channel " + (chan + 1)
//                            + " is now " + (1 == state ? "HIGH" : "LOW"));
                    System.out.println(String.format("@%s channel %d is now %s",
                            QUICK_DATE_FORMAT.format(ioEvent.timestamp), (chan + 1), (1 == state ? "HIGH" : "LOW")));

                    DigitalInputChannelEvent digitalInputEvent = new DigitalInputChannelEvent();
                    digitalInputEvent.Channel = (chan + 1);
                    digitalInputEvent.TransitionTime = ioEvent.timestamp;
                    digitalInputEvent.State = (1 == state);
                    digitalInputEvent.Counter = JANOS.getInputCounter(chan);
                    digitalInputEvent.UsageMeter = JANOS.getUsageMeter(chan);

                    for (IoChannelLogListener ioChannelListener : _ioChannelLogEventListeners) {
                        ioChannelListener.onIoChannelEvent(digitalInputEvent);
                    }
                }
            }
        }
    }



    @Override
    protected IoEvent[] getIoEvents() {
        return _iolog.getInputEvents();
    }
}

