package com.integ.janoslib.protocols.modbus.functions;

import java.io.DataOutputStream;
import java.io.IOException;

public abstract class ModbusFunctionRequest {

    protected final int _functionCode;
    protected final ModbusFunctionResponse _response;



    public ModbusFunctionRequest(int functionCode, ModbusFunctionResponse response) {
        _functionCode = functionCode;
        _response = response;
    }



    public int getFunctionCode() {
        return _functionCode;
    }



    public abstract int getRequestLength();



    public void write(DataOutputStream outputStream) throws IOException {
        outputStream.write(_functionCode);
    }



    public ModbusFunctionResponse getReponse() {
        return _response;
    }
}

