package com.integ.common.logging;

import java.util.Enumeration;
import java.util.Hashtable;

public class FileLogService implements Runnable {

        private static final FileLogService THIS = new FileLogService();
    protected static final Hashtable<String, Logger> LOGS_CACHE = new Hashtable<>();
    private static Thread _thread = null;



    /**
     * kicks off a thread that will call flush() on all of the Logger instances in the CACHE
     */
    public static void start() {
        if (null == _thread) {
            _thread = new Thread(THIS);
            _thread.setName(THIS.getClass().getName());
            _thread.setDaemon(true);
            _thread.start();
        }
    }



    /**
     * the thread loop that runs and makes sure all logs have been flushed within a reasonable amount of time
     */
    @Override
    public void run() {
        try {
            System.out.println("FileLogService started.");
            while (true) {
                Thread.sleep(1000);

                Enumeration<Logger> e = LOGS_CACHE.elements();
                while (e.hasMoreElements()) {
                    Logger log = e.nextElement();
                    log.flush();
                }
            }
        } catch (Exception ex) {
        }

        System.out.println("FileLogService done.");
    }

    
    @Override
    public void finalize() {
          System.out.println("finalize " + this.getClass().getName());
    }
}

