package com.integ.common.logging;

import com.integ.common.utils.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class BakLogOutputStream extends LogOutputStream {

    public BakLogOutputStream(LogOptions logOptions) throws FileNotFoundException {
        super(logOptions);
    }



    @Override
    protected int preWrite(byte[] b, int off, int len) throws IOException {
        // we are going to write some data.  if the length of new data puts us over the maximum size then we 
        // must trim the file to make room for it.
        if (_logOptions.getMaxFileSize() < _file.length() + len) {
            return bakFile(b, off, len);
        }
        return 0;
    }



    private int bakFile(byte[] b, int off, int len) throws IOException {
        long start = System.currentTimeMillis();

        // logic needed to finish off any unfinished entry and make sure the new log starts with a full entry.  Might
        // as well get as close to our max file size as we can in the process.
        //
        // get the remaining space
        int remainingSpace = _logOptions.getMaxFileSize() - (int) _file.length();

        // get the last valid \n
        while (0 < remainingSpace--) {
            if ('\n' == b[remainingSpace]) {
                FileUtils.appendBytes(_file.getPath(), b, off, remainingSpace++);
                break;
            }
        }

        File bakFile = new File(_logOptions.getFilePath() + ".bak");
        if (bakFile.exists()) {
            bakFile.delete();
        }

        _file.renameTo(bakFile);

        long elapsed = System.currentTimeMillis() - start;
        System.out.println(String.format("took %lld to create bak file for %s", elapsed, _file.getPath()));

        return remainingSpace;
    }

}

