package com.integ.common.net.protocols.modbus.functions;

import com.integpg.system.ArrayUtils;

public class WriteMultipleRegisters extends ModbusPdu {

    public WriteMultipleRegisters(int startingAddress, byte[] bytes) {
        this(startingAddress, bytes.length / 2, bytes);
    }



    public WriteMultipleRegisters(int startingAddress, int quantityOfRegisters, byte[] bytes) {
        super(16);

        byte[] data = new byte[bytes.length + 5];
        ArrayUtils.setShort(data, 0, (short) startingAddress);
        ArrayUtils.setShort(data, 2, (short) quantityOfRegisters);
        data[4] = (byte) bytes.length;
        ArrayUtils.arraycopy(bytes, 0, data, 5, bytes.length);
        super.setData(data);
    }
}

