//	JNIOR Automation Network Operating System (JANOS)
//  CopyRight (C) 2012-2016 INTEG process group inc. All Rights Reserved.

/* ---------------------------------------------------------------------------
 * This software is INTEG process group inc proprietary. This source code
 * is for internal company use only and any other use without prior
 * consent of INTEG process group inc is prohibited.
 *
 * Author: Bruce Cloutier
 * Inception Date: 28-Mar-2016
 * -------------------------------------------------------------------------*/

package com.integpg.system;

/**
 * Class represents an IO event in the Iolog history.
 * 
 * @author Bruce Cloutier
 */
public class IoEvent {
    
    /**
     * FLAGS_MASK1
     * ---- ---- XXXX ---- valid
     */
    public static final int FLAGS_MASK1 = 1;

    /**
     * FLAGS_MASK2
     * ---- XXXX ---- ---- valid
     */
    public static final int FLAGS_MASK2 = 2;

    /**
     * FLAGS_MASK3
     * XXXX ---- ---- ---- valid
     */
    public static final int FLAGS_MASK3 = 4;
    
    /**
     * timestamp the precise time of the event
     */
    public long timestamp;

    /**
     * mask bitwise mask indicating the channels affected by the event
     */
    public int mask;

    /**
     * states bitwise indication of the new states of the affected channels
     */
    public int states;

    /**
     * flags indicates the validity of channel groupings. This is affected by the addition or removal
     * of external modules depending on the JNIOR model in use.
     */
    public int flags;   
    
}
