package java.util;

//			Dictionary, Enumeration, HashtableEntry, HashtableEnumerator

/**
 * This class implements a hash table, which maps keys to values.
 * @param <K> Type used for Keys
 * @param <V> Type used for Values
 */
public class Hashtable<K,V>
    extends Dictionary<K,V>
	implements Cloneable
{

    /**
     * The hash table data.
     */
	private transient HashtableEntry[] table;

    /**
     * The total number of entries in the hash table.
     */
	private transient int count;
	private int threshold;
	private float loadFactor;
	private static final int DEFAULT_INITIAL_CAPACITY = 17;
	private static final float DEFAULT_LOAD_FACTOR = 0.75F;

    /**
     * Constructs a new, empty hashtable with a default initial capacity (11)
     * and load factor (0.75).
     */
    public Hashtable()
	{}

    /**
     * Constructs a new, empty hashtable with the specified initial capacity
     * and default load factor (0.75).
     *
     * @param initcap the initial capacity of the hashtable.
     */
    public Hashtable(int initcap)
	{}

    /**
     * Constructs a new, empty hashtable with the specified initial
     * capacity and the specified load factor.
     *
     * @param initcap the initial capacity of the hashtable.
     * @param loadfact the load factor of the hashtable.
     * @exception  IllegalArgumentException  if the initial capacity is less
     *             than zero, or if the load factor is nonpositive.
     */
    public Hashtable(int initcap, float loadfact)
	{}

    /**
     * Clears this hashtable so that it contains no keys.
     */
    public synchronized void clear()
	{}

    @Override
	public synchronized Hashtable<K,V> clone()
	{}

    /**
     * Tests if some key maps into the specified value in this hashtable.
     *
     * @param value a value to search for
     * @return <code>true</code> if and only if some key maps to the
     *             <code>value</code> argument in this hashtable as
     *             determined by the <tt>equals</tt> method;
     *             <code>false</code> otherwise.
     * @exception  NullPointerException  if the value is <code>null</code>
     */
    public synchronized boolean contains(Object value)
	{}

    /**
     * Tests if the specified object is a key in this hashtable.
     *
     * @param key possible key
     * @return  <code>true</code> if and only if the specified object
     *          is a key in this hashtable, as determined by the
     *          <tt>equals</tt> method; <code>false</code> otherwise.
     */
    public synchronized boolean containsKey(Object key)
	{}

    /**
     * Returns an enumeration of the values in this hashtable.
     *
     * @return  an enumeration of the values in this hashtable.
     */
    @Override
    public synchronized Enumeration<V> elements()
	{}

    /**
     * Returns the value to which the specified key is mapped,
     * or {@code null} if this map contains no mapping for the key.
     *
     * @param key the key whose associated value is to be returned
     * @return the value to which the specified key is mapped, or
     *         {@code null} if this map contains no mapping for the key
     * @throws NullPointerException if the specified key is null
     * @see     #put(Object, Object)
     */
    @Override
    public synchronized V get(K key)
	{}

    /**
     * Tests if this hashtable maps no keys to values.
     *
     * @return  <code>true</code> if this hashtable maps no keys to values;
     *          <code>false</code> otherwise.
     */
    @Override
    public boolean isEmpty()
	{}

    /**
     * Returns an enumeration of the keys in this hashtable.
     *
     * @return an enumeration of the keys
     */
    @Override
    public synchronized Enumeration<K> keys()
	{}

    /**
     * Maps the specified <code>key</code> to the specified
     * <code>value</code> in this hashtable. Neither the key nor the
     * value can be <code>null</code>. <p>
     *
     * The value can be retrieved by calling the <code>get</code> method
     * with a key that is equal to the original key.
     *
     * @param key the hashtable key
     * @param value the value
     * @return the previous value of the specified key in this hashtable,
     *             or <code>null</code> if it did not have one
     * @exception  NullPointerException  if the key or value is
     *               <code>null</code>
     */
    @Override
    public synchronized V put(K key, V value) {}

    /**
     * Increases the capacity of and internally reorganizes this
     * hashtable, in order to accommodate and access its entries more
     * efficiently.  This method is called automatically when the
     * number of keys in the hashtable exceeds this hashtable's capacity
     * and load factor.
     */
    protected void rehash()
	{}

    /**
     * Removes the key (and its corresponding value) from this
     * hashtable. This method does nothing if the key is not in the hashtable.
     *
     * @param key the key that needs to be removed
     * @return  the value to which the key had been mapped in this hashtable,
     *          or <code>null</code> if the key did not have a mapping
     * @throws  NullPointerException  if the key is <code>null</code>
     */
    @Override
    public synchronized V remove(K key)
	{}

    /**
     * Returns the number of keys in this hashtable.
     *
     * @return  the number of keys in this hashtable.
     */
    @Override
    public int size()
	{}

    /**
     * Returns a string representation of this <tt>Hashtable</tt> object
     * in the form of a set of entries, enclosed in braces and separated
     * by the ASCII characters "<tt>,&nbsp;</tt>" (comma and space). Each
     * entry is rendered as the key, an equals sign <tt>=</tt>, and the
     * associated element, where the <tt>toString</tt> method is used to
     * convert the key and element to strings.
     *
     * @return  a string representation of this hashtable
     */
    @Override
	public synchronized String toString()
	{}

}
