package com.integ.common.net.protocols.modbus.connections;

import com.integ.common.logging.Logger;
import com.integ.common.logging.SystemOutLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class ModbusConnection {

    protected Logger _log = SystemOutLog.getLogger();



    public void setLog(Logger log) {
        _log = log;
    }



    public abstract boolean isConnected();



    public abstract void closeConnection();



    public abstract InputStream getInputStream() throws IOException;



    public abstract OutputStream getOutputStream() throws IOException;



    public abstract void beginWrite() throws IOException;



    public abstract void endWrite(int bytesWritten);



    public void endWrite(byte[] bytes, int offset, int length) {
    }
}

