package com.integ.common.messagepump;

import com.integpg.system.SystemMsg;
import java.util.Json;

public class ApplicationSystemMsg extends SystemMsg {

    private final Json _json = new Json();



    public ApplicationSystemMsg(int type, String commandString) {
        this.type = type;
        _json.put("Message", commandString);
    }



    public ApplicationSystemMsg put(String name, Object value) {
        _json.put(name, value);
        return this;
    }



    @Override
    public String toString() {
        return _json.toString();
    }



    public ApplicationSystemMsg build() {
        this.msg = _json.toString().getBytes();
        return this;
    }

}

