package com.integ.janoslib.protocols.modbus.functions;

import java.io.DataInputStream;
import java.io.IOException;

public class ModbusFunctionResponse {

    protected int _functionCode;
    protected byte[] _data;



    public ModbusFunctionResponse(int functionCode) {
        _functionCode = functionCode;
    }



    public int getFunctionCode() {
        return _functionCode;
    }



    public byte[] getData() {
        return _data;
    }



    public boolean isError() {
        return ((getFunctionCode() & 0x80) != 0);
    }



    public int getErrorCode() {
        int errorCode = _data[0];
        System.out.println("errorCode: " + errorCode);
        return errorCode;
    }



    public void read(DataInputStream inputStream) throws IOException {
        int functionCode = inputStream.read();
        if (_functionCode != (functionCode & 0x7f)) {
            System.out.println("functionCode: " + functionCode + ", expected functionCode: " + _functionCode);
            throw new IOException("Function response code does not match request");
        }

        // overwrite the function code we have set as the returned function code may have the error bit set
        _functionCode = functionCode;
    }
}

