
package java.util;

// Referenced classes of package java.util:
//			NoSuchElementException, Enumeration

/**
 * The {@code Vector} class implements a growable array of
 * objects. Like an array, it contains components that can be
 * accessed using an integer index. However, the size of a
 * {@code Vector} can grow or shrink as needed to accommodate
 * adding and removing items after the {@code Vector} has been created.
 * 
 * @param <E> Entry type
 */
public class Vector<E>
	implements Cloneable
{

    /**
     * Array buffer into which elements are stored.
     */
    protected Object elementData[];

    /**
     * The number of elements stored.
     */
    protected int elementCount;

    /**
     * When the {@code Vector} needs to grow its size is increased by this
     *  amount.
     */
    protected int capacityIncrement;

    /**
     * Constructs an empty vector with the specified initial capacity set
     * to 6 and with its capacity increment equal to zero.
     *
     */
    public Vector()
	{}

    /**
     * Constructs an empty vector with the specified initial capacity and
     * with its capacity increment equal to zero.
     * 
     * @param initcap initial capacity
     */
    public Vector(int initcap)
	{}

    /**
     * Constructs an empty vector with the specified initial capacity and
     * capacity increment.
     *
     * @param initcap initial capacity?
     * @param capinc capacity increment
     */
    public Vector(int initcap, int capinc)
	{}

    /**
     * Adds an element to the end of the vector increasing its size
     * by 1.
     * 
     * @param obj an object to be added
     */
    public synchronized void addElement(E obj)
	{}

    /**
     * Returns the capacity of the vector (not the count of elements
     * that are stored within it).
     * 
     * @return capacity
     */
    public int capacity()
	{}

    /**
     * Returns a clone of this vector. The copy will contain a
     * reference to a clone of the internal data array, not a reference
     * to the original internal data array of this {@code Vector} object.
     *
     * @return  a clone of this vector
     */
	public synchronized Object clone()
	{}

    /**
     * Returns {@code true} if this vector contains the specified element.
     *
     * @param obj element whose presence is to be tested
     * @return {@code true} if this contains the element
     */
    public boolean contains(E obj)
	{}

    /**
     * Copies the components of this vector into the specified array.
     *
     * @param  aobj the array receiving the elements
     */
    public synchronized void copyInto(Object[] aobj)
	{}

    /**
     * Returns the element at the specified index.
     *
     * @param index an index into this vector
     * @return the element at the specified index
     */
    public synchronized E elementAt(int index)
	{}

    /**
     * Returns an enumeration of the components of this vector.
     *
     * @return  an enumeration of the components of this vector
     */
    public Enumeration<E> elements()
	{}

    /**
     * Increases the capacity of this vector, if necessary, to ensure
     * that it can hold at least the number of components specified by
     * the minimum capacity argument.
     *
     * @param mincap the desired minimum capacity
     */
    public synchronized void ensureCapacity(int mincap)
	{}

    /**
     * Returns the first component (the item at index {@code 0}) of
     * this vector.
     *
     * @return the first component of this vector
     * @throws NoSuchElementException if this vector has no components
     */
    public synchronized E firstElement()
	{}

	private void growMe()
	{}

    /**
     * Returns the index of the first occurrence of the specified element
     * in this vector, or -1 if this vector does not contain the element.
     *
     * @param obj element to search for
     * @return the index of the first occurrence of the specified element in
     *         this vector, or -1 if this vector does not contain the element
     */
    public int indexOf(Object obj)
	{}

    /**
     * Returns the index of the first occurrence of the specified element in
     * this vector, searching forwards from {@code index}, or returns -1 if
     * the element is not found.
     *
     * @param obj element to search for
     * @param index index to start searching from
     * @return the index of the first occurrence of the element in
     *         this vector at position {@code index} or later in the vector;
     *         {@code -1} if the element is not found.
     */
    public int indexOf(Object obj, int index)
	{}

    /**
     * Inserts the specified object as a component in this vector at the
     * specified {@code index}. Each component in this vector with
     * an index greater or equal to the specified {@code index} is
     * shifted upward to have an index one greater than the value it had
     * previously.
     *
     * @param obj the component to insert
     * @param index where to insert the new component
     * @throws ArrayIndexOutOfBoundsException if the index is out of range
     *         ({@code index < 0 || index > size()})
     */
    public synchronized void insertElementAt(E obj, int index)
	{}

    /**
     * Tests if this vector has no elements.
     *
     * @return  {@code true} if and only if this vector has
     *          no elements, that is, its size is zero;
     *          {@code false} otherwise.
     */
    public boolean isEmpty()
	{}

    /**
     * Returns the last element in the vector.
     *
     * @return  the last element in the vector
     * @throws NoSuchElementException if this vector is empty
     */
    public synchronized E lastElement()
	{}

    /**
     * Returns the index of the last occurrence of the specified element
     * in this vector, or -1 if this vector does not contain the element.
     *
     * @param obj element to search for
     * @return the index of the last occurrence of the specified element in
     *         this vector, or -1 if this vector does not contain the element
     */
    public int lastIndexOf(Object obj)
	{}

    /**
     * Returns the index of the last occurrence of the specified element in
     * this vector, searching backwards from {@code index}, or returns -1 if
     * the element is not found.
     *
     * @param obj element to search for
     * @param index index to start searching backwards from
     * @return the index of the last occurrence of the element at position
     *         less than or equal to {@code index} in this vector;
     *         -1 if the element is not found.
     */
    public synchronized int lastIndexOf(Object obj, int index)
	{}

    /**
     * Removes all elements from this vector and sets its size to zero.
     *
     */
    public synchronized void removeAllElements()
	{}

    /**
     * Removes the first (lowest-indexed) occurrence of the argument
     * from this vector. If the object is found in this vector, each
     * component in the vector with an index greater or equal to the
     * object's index is shifted downward to have an index one smaller
     * than the value it had previously.
     *
     * @param obj the component to be removed
     * @return {@code true} if the argument was a component of this
     *          vector; {@code false} otherwise.
     */
    public synchronized boolean removeElement(Object obj)
	{}

    /**
     * Deletes the component at the specified index. Each component in
     * this vector with an index greater or equal to the specified
     * {@code index} is shifted downward to have an index one
     * smaller than the value it had previously. The size of this vector
     * is decreased by {@code 1}.
     *
     * @param index the index of the object to remove
     * @throws ArrayIndexOutOfBoundsException if the index is out of range
     *         ({@code index < 0 || index >= size()})
     */
    public synchronized void removeElementAt(int index)
	{}

    /**
     * Sets the element at the specified {@code index} of this
     * vector to be the specified object. The previous component at that
     * position is discarded.
     *
     * @param obj what the component is to be set to
     * @param index the specified index
     * @throws ArrayIndexOutOfBoundsException if the index is out of range
     *         ({@code index < 0 || index >= size()})
     */
    public synchronized void setElementAt(E obj, int index)
	{}

    /**
     * Sets the size of this vector. If the new size is greater than the
     * current size, new {@code null} items are added to the end of
     * the vector. If the new size is less than the current size, all
     * components at index {@code newSize} and greater are discarded.
     *
     * @param size the new size of this vector
     */
    public synchronized void setSize(int size)
	{}

    /**
     * Returns the number of components in this vector.
     *
     * @return  the number of components in this vector
     */
    public int size()
	{}

    /**
     * Returns a string representation of this Vector, containing
     * the String representation of each element.
     */
	public synchronized String toString()
	{}

    /**
     * Trims the capacity of this vector to be the vector's current
     * size. If the capacity of this vector is larger than its current
     * size, then the capacity is changed to equal the size by replacing
     * its internal data array, kept in the field {@code elementData},
     * with a smaller one. An application can use this operation to
     * minimize the storage of a vector.
     */
    public synchronized void trimToSize()
	{}
}
