package java.util;

import com.integpg.system.Timebase;

public class SimpleTimeZone extends TimeZone
{

	private boolean useDST;
	private int startDay;
	private int startDayOfWeek;
	private int startMonth;
	private int startTime;
	private int startYear;
	private int endDay;
	private int endDayOfWeek;
	private int endMonth;
	private int endTime;
	private int rawOffset;
	static final int currentSerialVersion = 1;
	
    /**
     * Constructs a SimpleTimeZone with the given base time zone offset from GMT and time zone ID 
     * with no daylight saving time schedule.
     * 
     * @param offset The base time zone offset in milliseconds to UTC.
     * @param timezone  time zone name
     */
    public SimpleTimeZone(int offset, String timezone)
	{}

    /** Creates a SimpleTimeZone.
     * 
     * Exact day of month
     *  To specify an exact day of month, set the month and day-of-month to an exact value, and day-of-week to zero. 
     *  For example, to specify March 1, set the month to MARCH, day-of-month to 1, and day-of-week to 0.
     * 
     * Day of week on or after day of month
     *  To specify a day of week on or after an exact day of month, set the month to an exact month value, 
     *  day-of-month to the day on or after which the rule is applied, and day-of-week to a negative DAY_OF_WEEK 
     *  field value. For example, to specify the second Sunday of April, set month to APRIL, day-of-month to 8, 
     *  and day-of-week to -SUNDAY.
     * 
     * Day of week on or before day of month
     *  To specify a day of the week on or before an exact day of the month, set day-of-month and day-of-week 
     *  to a negative value. For example, to specify the last Wednesday on or before the 21st of March, set month 
     *  to MARCH, day-of-month is -21 and day-of-week is -WEDNESDAY.
     * 
     * Last day-of-week of month
     *  To specify, the last day-of-week of the month, set day-of-week to a DAY_OF_WEEK value and day-of-month 
     *  to -1. For example, to specify the last Sunday of October, set month to OCTOBER, day-of-week to SUNDAY 
     *  and day-of-month to -1.
     * 
     * @param ofs ?
     * @param abbr ?
     * @param stmon ?
     * @param stday ?
     * @param stdow ?
     * @param sttim ?
     * @param enmon ?
     * @param enday ?
     * @param endow ?
     * @param entim ?
     */
    public SimpleTimeZone(int ofs, String abbr, int stmon, int stday, int stdow, int sttim, int enmon,
			int enday, int endow, int entim)
	{}

	public Object clone() {}

	public boolean equals(Object obj) {}

    /**
     *
     * @param dayOfWeek ?
     * @param day ?
     * @param month ?
     * @param ruleDayOfWeek ?
     * @param ruleDay ?
     * @return Day associated with the rule
     */
	private static int figureOutRuleDay(int dayOfWeek, int day, int month, int ruleDayOfWeek, int ruleDay)
	{}

    /**
     * Gets the time zone offset, for current date, modified in case of daylight savings. This is the 
     * offset to add to UTC to get local time.
     * 
     * @param era the era of the given date
     * @param year the year of the given date
     * @param month the month in the given date (0-based, e.g. January is 0)
     * @param day the day of the month in the given date
     * @param dow the day of the week in the given date
     * @param tod the time of the day in milliseconds in standard local time
     * @return the offset in milliseconds (add to GMT to get local time)
     */
    public int getOffset(int era, int year, int month, int day, int dow, int tod) {}

    /**
     *
     * @return ?
     */
    public int getRawOffset()
	{}

	public synchronized int hashCode()
	{}

    /**
     *
     * @param date ?
     * @return ?
     */
    public boolean inDaylightTime(Date date)
	{}

    /**
     *
     * @param i ?
     * @param j ?
     * @param k ?
     * @param l ?
     */
    public void setEndRule(int i, int j, int k, int l)
	{}

    /**
     *
     * @param i ?
     */
    public void setRawOffset(int i)
	{}

    /**
     *
     * @param i ?
     * @param j ?
     * @param k ?
     * @param l ?
     */
    public void setStartRule(int i, int j, int k, int l)
	{}

    /**
     *
     * @param i ?
     */
    public void setStartYear(int i)
	{}

	public String toString()
	{}

    /** Retrieves the Daylight Saving Time (DST) enable flag.
     *
     * @return TRUE if Daylight Saving Time is to be used
     */
    public boolean useDaylightTime() {}

}
