//	JNIOR Automation Network Operating System (JANOS)
//  CopyRight (C) 2012-2016 INTEG process group inc. All Rights Reserved.

/* ---------------------------------------------------------------------------
 * This software is INTEG process group inc proprietary. This source code
 * is for internal company use only and any other use without prior
 * consent of INTEG process group inc is prohibited.
 *
 * Author: Bruce Cloutier
 * Inception Date: 9-Jun-2012
 * -------------------------------------------------------------------------*/

/*
 * Provides low-level native interface to the underlying JANOS standard C
 * library I/O.
 */

package com.integpg.comm;

import java.io.IOException;

/**
 *
 * @author Bruce Cloutier
 */
public class SerialInputStream
    extends java.io.InputStream
{

    /**
     * NULL output stream (bit bucket)
     */
    public static final int NULL = 0;

    /**
     * STDIN stream handles incoming data from the console
     */
    public static final int STDIN = 1;

    /** 
     * STDOUT stream generates outgoing data to the console
     */
    public static final int STDOUT = 2;

    /**
     * STDERR stream generates outgoing data to both the STDOUT stream and
     * to the {@code errors.log} file.
     */
    public static final int STDERR = 3;

    /**
     * COMIN stream handles incoming data from the RS-232 port (COM)
     */
    public static final int COMIN = 4;
    
    /**
     * COMOUT stream handles outgoing data to the RS-232 port (COM)
     */
    public static final int COMOUT = 5;
    
    /**
     * AUXIN stram handles incoming data from the AUX serial port
     */
    public static final int AUXIN = 6;

    /**
     * AUXOUT stram handles outgoing data to the AUX serial port
     */
    public static final int AUXOUT = 7;

    private boolean inputEcho = true;

    // Handle for the input stream

    /**
     * The default input handle is STDIN
     */
    public int inputHandle  = STDIN;

    // Handle for the output stream used for echo

    /**
     * The default output handle is STDOUT
     */
    public int echoHandle = STDOUT;

    /**
     * Creates a serial connection
     */
    public SerialInputStream ()
    {}

    /**
     *
     * @param hnd_in ?
     * @param hnd_out ?
     */
    public SerialInputStream (int hnd_in, int hnd_out)
    {}

    /**
     * open the port
     */
    protected void open ()
    {}

    /**
     * close the port
     */
    @Override
    public void close ()
    {}

    // Retrieve character from the stream (blocking)
    private static native int getchar(int handle);

    // Retrieve count of pending input data in the stream
    private static native int avail(int handle);

    // Transmit character to the output stream
    private static native void putchar(int ch, int handle);

    /**
     * Reads a character from the stream. This method blocks for a timeout period and
     * returns -1 on timeout.
     * 
     * @return character read from the stream (-1 on timeout)
     * @throws java.io.IOException on timeout
     */
    @Override
    public synchronized int read ()
		throws IOException
    {}

    /**
    * Returns the number of bytes that can be read from this input
    * stream without blocking.
    * 
     * @return count of bytes available
    */
    @Override
    public synchronized int available () {}

    /**
    * Turns on and off echoing back characters read by this stream.
    * 
     * @param echo true if received data is to be echoed
    */
    public synchronized void setEcho (boolean echo) {}

    void enableReceiveThreshold(int thresh)
    {}

    private static native void commSetThreshEnable(int handle, int n);

    void disableReceiveThreshold()
    {}

    boolean isReceiveThresholdEnabled()
    {}

    private static native int commGetThreshEnable(int handle);

    void enableReceiveTimeout(int rcvTimeout)
    {}

    private static native void commSetTimeout(int handle, int timeout);

    void disableReceiveTimeout()
    {}

    boolean isReceiveTimeoutEnabled()
    {}

    private static native int commGetTimeout(int handle);

    int getHandle() {}

}
