//	JNIOR Automation Network Operating System (JANOS)
//  CopyRight (C) 2012-2016 INTEG process group inc. All Rights Reserved.

/* ---------------------------------------------------------------------------
 * This software is INTEG process group inc proprietary. This source code
 * is for internal company use only and any other use without prior
 * consent of INTEG process group inc is prohibited.
 *
 * Author: Bruce Cloutier
 * Inception Date: 
 * -------------------------------------------------------------------------*/

package com.integpg.system;

/**
 * A SHA-1 Hash and a "Better than Java" random number generator.
 */
public class Security {
        
    static public final int PUBKEY = 0;
    static public final int PRIVKEY = 1;

   /**
    * Don't allow instantiation.
    */
   private Security ()
   {}

   /**
    * Computes MD5 message digest for the given message.
    *
    * @param message the message to hash
    *
    * @return the result of the hash (16 bytes)
    */
   public static byte[] messageDigest(byte[] message)
   {}

   /**
    * Computes MD5 message digest for the given message.
    *
    * @param msg the message to hash
    * @param msgoffs offset into the message array
    * @param msglen length of the message to hash
    * @param hash holds the hash value on return (16 bytes minimum)
    * @param hashoffs offset into the hash value array
    */
   public static native void messageDigest(byte[] msg, int msgoffs, int msglen, byte[] hash, int hashoffs);

   /**
    * Computes a SHA-1 hash on the given message.
    * <br>See FIPS 180-1 for more information on SHA-1.
    *
    * @param message the message to hash
    *
    * @return the result of the hash (20 bytes)
    */
   public static byte[] hashMessage(byte[] message)
   {}

   /**
    * Computes a SHA-1 hash on the given message.
    * <br>See FIPS 180-1 for more information on SHA-1.
    *
    * @param msg the message to hash
    * @param msgoffs offset into the message array
    * @param msglen length of the message to hash
    * @param hash holds the hash value on return (20 bytes minimum)
    * @param hashoffs offset into the hash value array
    */
   public static native void hashMessage(byte[] msg, int msgoffs, int msglen, byte[] hash, int hashoffs);

   /**
    * Computes a SHA-256 hash on the given message.
    *
    * @param message the message to hash
    *
    * @return the result of the hash (32 bytes)
    */
   public static byte[] hashMessage256(byte[] message)
   {}

   /**
    * Computes a SHA-256 hash on the given message.
    *
    * @param msg the message to hash
    * @param msgoffs offset into the message array
    * @param msglen length of the message to hash
    * @param hash holds the hash value on return (20 bytes minimum)
    * @param hashoffs offset into the hash value array
    */
   public static native void hashMessage256(byte[] msg, int msgoffs, int msglen, byte[] hash, int hashoffs);

   /**
    * Encodes the data using Base64
    *
    * @param msg the message to encode
    * @param msgoffs offset into the message array
    * @param msglen length of the message
    * @return the result of the encoding
    */
   public static native byte[] b64encode(byte[] msg, int msgoffs, int msglen);

   /**
    * Decode the data using Base64
    *
    * @param msg the message to decode
    * @param msgoffs offset into the message array
    * @param msglen length of the message
    * @return the result of the decoding
    */
   public static native byte[] b64decode(byte[] msg, int msgoffs, int msglen);

   /**
    * Perform RC4 cipher
    *
    * @param msg the message to encrypt/decrypt
    * @param msglen length of the message
    * @param key RC4 key of length less than or equal to 256 bytes (maximum 2048 bits)
    * @return the result of the cipher operation
    */
   public static native byte[] rc4cipher(byte[] msg, int msglen, byte[] key);

   /**
     * Perform RSA encryption using current RSA private key
     * 
     * @param msg array of bytes to be encrypted
     * @return encrypted message as byte array
     */
   public static byte[] encrypt(byte[] msg) {}

   /**
     * Perform RSA encryption using current RSA key
     * 
     * @param msg array of bytes to be encrypted
     * @param msglen count of bytes to encrypt
     * @param priv internal key to use: public (0) or private (1)
     * @return encrypted message as byte array
     */
   public static byte[] encrypt(byte[] msg, int msglen, int priv) {}

   /**
     * Perform RSA encryption
     * 
     * @param msg array of bytes to be encrypted
     * @param msglen count of bytes to encrypt
     * @param pubkey RSA public key in PEM format for encryption or null if internal used
     * @param priv internal key to use: public (0) or private (1)
     * @return encrypted message as byte array
     */
   public static native byte[] encrypt(byte[] msg, int msglen, byte[] pubkey, int priv);

   /**
     * Perform RSA decryption using current RSA public key
     * 
     * @param msg array of bytes to be decrypted
     * @return decrypted message as byte array
     */
   public static byte[] decrypt(byte[] msg) {}

   /**
     * Perform RSA decryption using current RSA key
     * 
     * @param msg array of bytes to be decrypted
     * @param msglen count of bytes to decrypt
     * @param priv internal key to use: public (0) or private (1)
     * @return decrypted message as byte array
     */
   public static byte[] decrypt(byte[] msg, int msglen, int priv) {}

   /**
     * Perform RSA decryption
     * 
     * @param msg array of bytes to be decrypted
     * @param msglen count of bytes to decrypt
     * @param pubkey RSA public key in PEM format for decryption or null if internal used
     * @param priv internal key to use: public (0) or private (1)
     * @return decrypted message as byte array
     */
   public static native byte[] decrypt(byte[] msg, int msglen, byte[] pubkey, int priv);

   /**
     * Obtain internal public key in PEM format.
     * 
     * @return public key in PEM format.
     */
   public static native byte[] pubkey();
}

