package com.integ.common.utils;

public class StringUtils {

    public static String[] split(String str, String delim) {
        return split(str, new String[]{ delim }, 0);
    }



    public static String[] split(String str, String delim, int index) {
        return split(str, new String[]{ delim }, index);
    }



    public static String[] split(String str, String[] delim, int index) {
        if (null == str) return new String[0];

        int startIndex = index;

        int[] delimPosArray = new int[delim.length];
        for (int delimIndex = 0; delimIndex < delimPosArray.length; delimIndex++) {
            delimPosArray[delimIndex] = str.indexOf(delim[delimIndex]);
//            System.out.println("Delim Index for " + delim[delimIndex] + " is " + delimPosArray[delimIndex]);
        }


//        System.out.println("Split " + str.substring(index));
//        long start = JANOS.uptimeMillis();
        int delimPos = 0, count = 0;

        // get the number of string elements we should end up with
        while (true) {
            int nextDelimIndex = -1, nextDelimPos = Integer.MAX_VALUE;
            for (int delimIndex = 0; delimIndex < delimPosArray.length; delimIndex++) {
                if (delimPosArray[delimIndex] < nextDelimPos) {
                    nextDelimIndex = delimIndex;
                    nextDelimPos = delimPosArray[delimIndex];
                }
            }

            if (nextDelimIndex == -1 || (delimPos = str.indexOf(delim[nextDelimIndex], index)) == -1) {
                break;
            }

            count++;
            index = delimPos + delim[nextDelimIndex].length();
            delimPosArray[nextDelimIndex] = str.indexOf(delim[nextDelimIndex], index);
            if (delimPosArray[nextDelimIndex] == -1) {
                delimPosArray[nextDelimIndex] = str.length();
            }
//            System.out.println("Delim Index for " + delim[nextDelimIndex] + " is " + delimPosArray[nextDelimIndex]);

            if (index == str.length()) {
                count++;
            }
        }

        if (index != str.length()) {
            count++;
        }


        for (int delimIndex = 0; delimIndex < delimPosArray.length; delimIndex++) {
            delimPosArray[delimIndex] = str.indexOf(delim[delimIndex]);
//            System.out.println("Delim Index for " + delim[delimIndex] + " is " + delimPosArray[delimIndex]);
        }


        // go through and load our string array
        String[] arr = new String[count];
        int i = 0;
        index = startIndex;
        while (true) {
            int nextDelimIndex = -1, nextDelimPos = Integer.MAX_VALUE;
            for (int delimIndex = 0; delimIndex < delimPosArray.length; delimIndex++) {
                if (delimPosArray[delimIndex] < nextDelimPos) {
                    nextDelimIndex = delimIndex;
                    nextDelimPos = delimPosArray[delimIndex];
                }
            }

            if (nextDelimIndex == -1 || (delimPos = str.indexOf(delim[nextDelimIndex], index)) == -1) {
                break;
            }

            arr[i++] = str.substring(index, delimPos).trim();
            index = delimPos + delim[nextDelimIndex].length();
            delimPosArray[nextDelimIndex] = str.indexOf(delim[nextDelimIndex], index);
            if (delimPosArray[nextDelimIndex] == -1) {
                delimPosArray[nextDelimIndex] = str.length();
            }
//            System.out.println("Delim Index for " + delim[nextDelimIndex] + " is " + delimPosArray[nextDelimIndex]);

            if (index == str.length()) {
                arr[i++] = "";
            }
        }

        if (index != str.length()) {
            arr[i] = str.substring(index).trim();
        }

//        long elapsed = JANOS.uptimeMillis() - start;
//        System.out.println("split took " + elapsed);

        // return
        return arr;
    }



    public static String join(String[] dataArray, String delimiter) {
        StringBuilder sb = new StringBuilder();

        for (String s : dataArray) {
            if (0 < sb.length()) sb.append(delimiter);
            sb.append(s);
        }

        return sb.toString();
    }



    public static String trim(String s, char c) {
        s = trimStart(s, c);
        s = trimEnd(s, c);
        return s;
    }



    public static String trimStart(String s, char c) {
        while (s.charAt(0) == c) {
            s = s.substring(1);
        }
        return s;
    }



    public static String trimEnd(String s, char c) {
        int lastIndexPos = s.length();
        while (0 < lastIndexPos && s.charAt(lastIndexPos - 1) == c) {
            lastIndexPos--;
        }
        s = s.substring(0, lastIndexPos);
        return s;
    }



    public static String replaceAll(String original, String target, String replace) {
//        System.out.println("replace " + target + " with " + replace + " in " + original);
        StringBuilder sb = new StringBuilder(original.length());
        int pos = 0, lastPos = 0;
        while ((pos = original.indexOf(target, lastPos)) >= 0) {
//            System.out.println("found " + target + " at " + pos);
            sb.append(original.substring(lastPos, pos));
            sb.append(replace);
            lastPos = pos + target.length();
        }
        if (original.length() != lastPos) {
            sb.append(original.substring(lastPos));
        }
        String result = sb.toString();
//        System.out.println(result);
        return result;
    }



    public static byte[] getEscapedBytes(String string) {
        String newTermString = "";
        boolean backslashFound = false;
        for (int i = 0; i < string.length(); i++) {
            if (string.charAt(i) == '\\' && !backslashFound) {
                backslashFound = true;
            } else {

                if (backslashFound) {
                    switch (string.charAt(i)) {
                        case 'r':
                            newTermString += '\r';
                            break;
                        case 'n':
                            newTermString += '\n';
                            break;
                        case 't':
                            newTermString += '\t';
                            break;
                        case 'f':
                            newTermString += '\f';
                            break;
                        case 'b':
                            newTermString += '\b';
                            break;
                        case '0':
                            newTermString += '\0';
                            break;
                        case '\"':
                            newTermString += '\"';
                            break;
                        case 'x':
                            // get the next two digits
                            String s = string.substring(i + 1, i + 3);
//                            System.out.println("\\x " + s + " " + Integer.parseInt(s, 16));
                            newTermString += (char) Integer.parseInt(s, 16);
                            i += 2;
                    }
                } else {
                    newTermString += string.charAt(i);
                }
                backslashFound = false;
            }
        }
        return newTermString.getBytes();
    }



    public static boolean isNullOrEmpty(String s) {
        return (null == s || "".equals(s));
    }

}

