package com.integ.common.messagepump;

import com.integ.common.logging.Logger;
import com.integ.common.logging.SystemOutLog;
import com.integpg.system.SystemMsg;
import java.util.Hashtable;
import java.util.Json;

public class MessagePumpAppHandler implements MessagePumpListener {

    private final Hashtable<String, MessagePumpAppMessageListener> _appMessageListeners = new Hashtable<>();
    private final int _type;

    private static Logger _log = SystemOutLog.getLogger();

    private SystemMsg _systemMsg;
    private Json _receivedJson;
    private String _messageString;



    public MessagePumpAppHandler(int type) {
        _type = type;
    }



    public static void setLog(Logger log) {
        _log = log;
    }



    public MessagePumpAppHandler addCommandListener(String command, MessagePumpAppMessageListener listener) {
        _appMessageListeners.put(command, listener);
        _log.info(String.format("   added handler for %s:%d = %s",
                command, _type, listener.getClass().getName()));
        return this;
    }



    @Override
    public void messageReceived(SystemMsg systemMsg) {
        if (_type == systemMsg.type) {
            _systemMsg = systemMsg;

            long start = System.currentTimeMillis();
            processMessage();
            long elapsed = System.currentTimeMillis() - start;
            if (100 <= elapsed) {
                _log.warn(String.format("%s processed in %.3f",
                        _messageString, (elapsed / 1000.0)));
            }
        }
    }



    private void processMessage() {
        String contentJsonString = new String(_systemMsg.msg);
        _receivedJson = new Json(contentJsonString);
        _messageString = _receivedJson.getString("Message");
        _log.info(String.format("%s processing %s", this.getClass().getName(), _messageString));
        _log.info(String.format("listeners containsKey %s = %s",
                _messageString, String.valueOf(_appMessageListeners.containsKey(_messageString))));

        if (_appMessageListeners.containsKey(_messageString)) {
            MessagePumpAppMessageListener listener = _appMessageListeners.get(_messageString);
            if (null != listener) {
                listener.applicationMessageReceived(_receivedJson);
            }
        }

    }



    private void sendReponse(Json json) {
        // generate a response and post it to the message pump
        SystemMsg responseMsg = new SystemMsg();
        responseMsg.type = _systemMsg.type;
        responseMsg.msg = json.toString().getBytes();
        MessagePumpEngine.postMessage(responseMsg);
    }

}

