/*
 * Decompiled with CFR 0.152.
 */
package dmxport;

import com.integpg.comm.AUXSerialPort;
import com.integpg.comm.SerialOutputStream;
import com.integpg.system.Immutable;
import com.integpg.system.JANOS;
import com.integpg.system.Watchdog;

public class DMXPORT {
    static final String SHARED_MEMORY = "DMX512_1";
    static boolean TEST = false;

    public static void main(String[] args) {
        if (args.length == 1 && args[0].equals("-TEST")) {
            TEST = true;
        }
        JANOS.syslog((String)"Starting DMX512 stream");
        DMXport dmx = new DMXport();
        Thread t = new Thread(dmx);
        t.start();
    }

    private static class DMXport
    implements Runnable {
        private byte[] data = Immutable.getByteArray((String)"DMX512_1");

        private DMXport() {
        }

        @Override
        public void run() {
            try {
                if (this.data == null) {
                    this.data = Immutable.createByteArray((String)DMXPORT.SHARED_MEMORY, (int)512);
                }
                if (this.data.length != 512) {
                    Immutable.remove((String)DMXPORT.SHARED_MEMORY);
                    this.data = Immutable.createByteArray((String)DMXPORT.SHARED_MEMORY, (int)512);
                }
                if (TEST) {
                    this.data = new byte[512];
                    for (int n = 0; n < 256; ++n) {
                        this.data[2 * n] = (byte)n;
                        this.data[2 * n + 1] = (byte)(255 - n);
                    }
                }
                AUXSerialPort aux = new AUXSerialPort();
                aux.open();
                aux.setSerialPortParams(250000, 8, 2, 0);
                aux.setRS485(true);
                aux.enableReceivers(false);
                aux.enableDrivers(true);
                aux.setOutputBufferSize(2048);
                Watchdog watchdog = new Watchdog("DMX Port");
                watchdog.setAction(4);
                watchdog.activate(2500);
                SerialOutputStream auxout = aux.getOutputStream();
                while (true) {
                    aux.sendMarkAfterBreak(100, 12);
                    Thread.yield();
                    auxout.write(0);
                    auxout.write(this.data, 0, 512);
                    auxout.flush();
                    watchdog.refresh();
                }
            }
            catch (Throwable t) {
                System.out.println(t);
                return;
            }
        }
    }
}

