/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx.actions;

import com.integpg.dmx.DmxMain;
import com.integpg.dmx.actions.At;
import com.integpg.dmx.actions.Command;
import com.integpg.dmx.lexer.Lexer;
import com.integpg.dmx.lexer.Token;
import com.integpg.dmx.lexer.TokenStream;
import com.integpg.janoslib.collections.Queue;
import com.integpg.janoslib.logging.AppLog;
import java.util.ArrayList;

public class SetChannelCommand
extends Command {
    private String _commandString;
    private TokenStream _tokenStream = null;
    private ArrayList<Integer> _channels = new ArrayList();
    private ArrayList<Integer> _values = new ArrayList();
    private int _minChannel = 512;
    private int _maxChannel = 0;
    private byte[] _byteArray = null;
    private byte[] _channelMask = null;

    public SetChannelCommand(String commandString) throws Exception {
        this._commandString = commandString;
        this.tokens.clear();
        try {
            Lexer.parse(this.tokens, commandString);
            this._tokenStream = new TokenStream(this.tokens);
            this.parseCommand();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public String getCommandString() {
        return this._commandString;
    }

    private void nextToken() {
        this._tokenStream.nextToken();
    }

    private void printTokens(Queue tokens) {
        try {
            System.out.println("Parser found " + tokens.size() + " tokens");
            for (int i = 0; i < tokens.size(); ++i) {
                Token token = (Token)tokens.elementAt(i);
                System.out.println("token: " + token);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void parseCommand() {
        while (null != this._tokenStream.getCurrent()) {
            int i;
            int endingChannel;
            int startingChannel = this.getChannel();
            if (this._minChannel > startingChannel) {
                this._minChannel = startingChannel;
            }
            if (this._maxChannel < startingChannel) {
                this._maxChannel = startingChannel;
            }
            this._channels.add(startingChannel);
            if (this._tokenStream.isEmpty()) break;
            this.nextToken();
            if (45 == this._tokenStream.getCurrent().type) {
                this.nextToken();
                endingChannel = this.getChannel();
                if (this._minChannel > endingChannel) {
                    this._minChannel = endingChannel;
                }
                if (this._maxChannel < endingChannel) {
                    this._maxChannel = endingChannel;
                }
                for (i = startingChannel + 1; i <= endingChannel; ++i) {
                    this._channels.add(i);
                }
                this.nextToken();
            } else if (3 == this._tokenStream.getCurrent().type) {
                endingChannel = this.getChannel();
                if (0 < endingChannel) {
                    throw new RuntimeException("Range Expected");
                }
                if (this._minChannel > (endingChannel = Math.abs(endingChannel))) {
                    this._minChannel = endingChannel;
                }
                if (this._maxChannel < endingChannel) {
                    this._maxChannel = endingChannel;
                }
                for (i = startingChannel + 1; i <= endingChannel; ++i) {
                    this._channels.add(i);
                }
                this.nextToken();
            }
            if (61 == this._tokenStream.getCurrent().type) break;
            if (44 != this._tokenStream.getCurrent().type) {
                throw new RuntimeException("Comma Expected");
            }
            this.nextToken();
        }
        this.nextToken();
        while (null != this._tokenStream.getCurrent()) {
            int value = this.getValue();
            this._values.add(value);
            if (this._tokenStream.isEmpty()) break;
            this.nextToken();
            if (44 != this._tokenStream.getCurrent().type) {
                throw new RuntimeException("Comma Expected");
            }
            this.nextToken();
        }
        int channelCount = this._maxChannel - this._minChannel + 1;
        this._byteArray = new byte[channelCount];
        this._channelMask = new byte[64];
        int valueIndex = 0;
        for (int channelIndex = 0; channelIndex < this._channels.size(); ++channelIndex) {
            int channelOffset;
            int channel = this._channels.get(channelIndex);
            int value = this._values.get(valueIndex);
            this._byteArray[channel - this._minChannel] = (byte)value;
            int n = channelOffset = (channel - 1) / 8;
            this._channelMask[n] = (byte)(this._channelMask[n] | (byte)(1 << (channel - 1) % 8));
            valueIndex = (valueIndex + 1) % this._values.size();
        }
    }

    private int getChannel() {
        try {
            Token token = this._tokenStream.getCurrent();
            if (3 != token.type) {
                throw new RuntimeException("Numeric Channel Expected");
            }
            int channel = Integer.parseInt(token.content);
            return channel;
        }
        catch (Exception ex) {
            AppLog.error("Error getting channel", ex);
            return Integer.MIN_VALUE;
        }
    }

    private int getValue() {
        try {
            Token token = this._tokenStream.getCurrent();
            if (3 != token.type) {
                throw new RuntimeException("Numeric Value Expected");
            }
            int value = Integer.parseInt(token.content);
            return value;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AppLog.error("Error getting channel", ex);
            return Integer.MIN_VALUE;
        }
    }

    @Override
    public void execute(At at) {
        DmxMain.DMX_PORTS[0].setChannels(this._minChannel, this._byteArray, this._channelMask);
    }
}

