/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx.actions;

import com.integpg.dmx.ScriptExecutor;
import com.integpg.dmx.actions.At;
import com.integpg.dmx.actions.Command;
import com.integpg.janoslib.logging.AppLog;

public class AbortCommand
extends Command {
    private final String _thisScriptName;
    private final String _scriptToAbort;
    private final boolean _abortAll;

    public AbortCommand(String scriptName, String parameters) {
        this._thisScriptName = scriptName;
        this._scriptToAbort = parameters;
        this._abortAll = null == this._scriptToAbort || "*".equals(this._scriptToAbort);
    }

    @Override
    public void execute(At at) {
        try {
            if (this._abortAll) {
                ScriptExecutor.abortAllExcept(this._thisScriptName);
            } else {
                ScriptExecutor.abort(this._scriptToAbort);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            AppLog.error(String.format("error executing abort command(%s)", this._scriptToAbort), ex);
        }
        AppLog.info("abort complete");
    }
}

