/* global bootbox, DmxApp */

DmxApp.controller('FixtureController', function ($scope, $compile, FixtureService, FixtureTypeService) {
    var _this = this;
    _this.NewFixture = {};
    _this.dialogBody = "<div id='add-fixture'>\r\n" +
        // "<div class='row form-group'>\r\n" +
        // "  <div class='col-sm-4'><label class='inline-with-control'>Fixture ID</label></div>" +
        // "  <div class='col-sm-6'><label class='inline-with-control'>{{fixtureCtrl.NewFixture.Id}}</label></div>" +
        // "</div>\r\n" +
        "<div class='row form-group'>\r\n" +
        "  <div class='col-sm-4'><label class='inline-with-control'>Fixture Type</label></div>" +
        "  <div class='col-sm-6'>\r\n" +
        "    <select class='form-control'" +
        "      ng-model='fixtureCtrl.NewFixture.FixtureTypeId' ng-change='eachChannel()' ng-style='(!fixtureCtrl.NewFixture || !fixtureCtrl.NewFixture.FixtureTypeId || null === fixtureCtrl.NewFixture.FixtureTypeId) ? {\"border-color\" : \"#ff8080\"} : {}'\r\n" +
        "        ng-options='fixtureType.Id as fixtureType.Name for fixtureType in fixtureCtrl.getFixtureTypes()'>" +
        "      <option></option>\r\n" +
        "    </select>\r\n" +
        "  </div>" +
        "</div>" +
        "<div class='row form-group'>\r\n" +
        "  <div class='col-sm-4'><label class='inline-with-control'>Fixture Name</label></div>" +
        "  <div class='col-sm-6'>\r\n" +
        "    <input class='form-control' type='text' ng-model='fixtureCtrl.NewFixture.Name' ng-style='(!fixtureCtrl.NewFixture || !fixtureCtrl.NewFixture.Name || null === fixtureCtrl.NewFixture.Name) ? {\"border-color\" : \"#ff8080\"} : {}'>\r\n" +
        "  </div>" +
        "</div>" +
        "<div class='row form-group'>\r\n" +
        "  <div class='col-sm-4'><label class='inline-with-control'>Starting DMX Channel</label></div>" +
        "  <div class='col-sm-2'>\r\n" +
        "    <input class='form-control' type='number' min='1' max='512'\r\n" +
        "      ng-model='fixtureCtrl.NewFixture.StartChannel' ng-style='(!fixtureCtrl.NewFixture || !fixtureCtrl.NewFixture.StartChannel || null === fixtureCtrl.NewFixture.StartChannel) ? {\"border-color\" : \"#ff8080\"} : {}'>\r\n" +
        "  </div>" +
        "</div>" +
        "</div>";



    _this.getFixtures = function () {
        return FixtureService.Config.Fixtures;
    };


    _this.getFixtureTypes = function () {
        return FixtureTypeService.Config.FixtureTypes;
    };


    _this.getFixtureType = function (fixture) {
        var fixtureTypes = _this.getFixtureTypes();
        for (var index = 0; index < fixtureTypes.length; index++) {
            if (fixture.FixtureTypeId == fixtureTypes[index].Id) {
                return fixtureTypes[index];
            }
        }
        return null;
    };


    _this.hasFixtureBeenRemoved = function (fixture) {
        return FixtureService.hasFixtureBeenRemoved(fixture);
    };


    _this.hasFixtureChanged = function (fixture) {
        return FixtureService.hasFixtureChanged(fixture);
    };


    _this.save = function () {
        FixtureService.save();
    };


    _this.addFixture = function () {
        FixtureService.EditDialog = bootbox.dialog({
            title: "Add a new fixture",
            message: _this.dialogBody,
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Add',
                    className: 'btn-success',
                    callback: function (result) {
                        if (result) {
                            var fixture = angular.copy(_this.NewFixture);
                            fixture.Added = true;
                            FixtureService.Config.Fixtures.push(fixture);
                            $scope.$apply();
                        }
                    }
                }
            }
        });
        FixtureService.EditDialog.init(function () {
            _this.NewFixture = { Id: parseInt(new Date().getTime() / 1000) };

            FixtureService.EditDialog.attr('id', 'new-fixture-dialog');
            $(".modal-header").css("background-color", "#428bca");
            $(".modal-header").css("color", "#fff");

            $('#bootbox-confirm-btn').attr('ng-disabled', '!(fixtureCtrl.NewFixture && fixtureCtrl.NewFixture.Name && fixtureCtrl.NewFixture.FixtureTypeId && fixtureCtrl.NewFixture.StartChannel)');

            // finally compile our new controller
            var linkFn = $compile(angular.element(FixtureService.EditDialog));
            var html = linkFn($scope);
        });
    };


    _this.editFixture = function (fixture) {
        FixtureService.EditDialog = bootbox.dialog({
            title: "Edit fixture",
            message: _this.dialogBody,
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Done',
                    className: 'btn-success',
                    callback: function (result) {
                        if (result) {
                            if (!fixture.OldName) {
                                fixture.OldName = fixture.Name;
                            }
                            if (!fixture.OldFixtureTypeId) {
                                fixture.OldFixtureTypeId = fixture.FixtureTypeId;
                            }
                            if (!fixture.OldStartChannel) {
                                fixture.OldStartChannel = fixture.StartChannel;
                            }
                            fixture.Name = _this.NewFixture.Name;
                            fixture.FixtureTypeId = _this.NewFixture.FixtureTypeId;
                            fixture.StartChannel = _this.NewFixture.StartChannel;
                            $scope.$apply();
                        }
                    }
                }
            }
        });
        FixtureService.EditDialog.init(function () {
            if (undefined === fixture.Id) {
                fixture.Id = parseInt(new Date().getTime() / 1000);
            }
            _this.NewFixture = angular.copy(fixture);

            FixtureService.EditDialog.attr('id', 'edit-fixture-dialog');
            $(".modal-header").css("background-color", "#428bca");
            $(".modal-header").css("color", "#fff");

            $('#bootbox-confirm-btn').attr('ng-disabled', '!(fixtureCtrl.NewFixture && fixtureCtrl.NewFixture.Name && fixtureCtrl.NewFixture.FixtureTypeId && fixtureCtrl.NewFixture.StartChannel)');

            // finally compile our new controller
            var linkFn = $compile(angular.element(FixtureService.EditDialog));
            var html = linkFn($scope);
        });
    };


    _this.removeFixture = function (fixture) {
        var dialog = bootbox.confirm({
            title: "Remove Fixture",
            message: "Are you sure you want to remove the '" + fixture.Name + "' fixture?",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Remove',
                    className: 'btn-danger'
                }
            },
            callback: function (result) {
                if (result) {
                    if (fixture.Added) {
                        var index = FixtureService.Config.Fixtures.indexOf(fixture);
                        if (index > -1) {
                            FixtureService.Config.Fixtures.splice(index, 1);
                        }
                    } else {
                        fixture.Removed = true;
                    }

                    $scope.$apply();
                }
            }
        });
        dialog.init(function () {
            $(".modal-header").css("background-color", "#d9534f");
            $(".modal-header").css("color", "#fff");
        });
    };


    _this.openFixture = function (fixture) {
        var fixtureType = null;
        if (fixture.FixtureTypeId) {
            fixtureType = _this.getFixtureType(fixture);

            windowObjectReference = window.open(
                "panel/fixture.html?fixtureName=" + fixture.Name,
                fixture.Name,
                "width=" + (Math.floor(((fixtureType.ChannelCount - 1) / 16) + 1) * 290) + ",height=700,resizable,scrollbars=no,status=0,location=0"
            );
        }
    };
});



DmxApp.service('FixtureService', function ($rootScope) {
    var _this = this;
    _this.Config = {};
    _this.Config.Fixtures = [];
    _this.SavedConfig = angular.copy(_this.Config);

    _this.EditDialog = null;
    _this.$scope = null;


    _this.hasChanged = function () {
        for (var i = 0; i < _this.Config.Fixtures.length; i++) {
            var fixture = _this.Config.Fixtures[i];
            if (_this.hasFixtureBeenRemoved(fixture)
                || _this.hasFixtureChanged(fixture)) {
                return true;
            }
        }
        return false;
    };


    _this.hasFixtureBeenRemoved = function (fixture) {
        return (fixture.Removed);
    };


    _this.hasFixtureChanged = function (fixture) {
        return (fixture.Added)
            || (fixture.OldName && fixture.OldName !== fixture.Name)
            || (fixture.OldFixtureTypeId && fixture.OldFixtureTypeId !== fixture.FixtureTypeId)
            || (fixture.OldStartChannel && fixture.OldStartChannel !== fixture.StartChannel);
    };


    _this.load = function ($scope) {
        _this.$scope = $scope;
        JnrWebsocket.readFile("/flash/dmx/fixtures/fixtures.json").then(_this.fixtureFileRead);
    };


    _this.fixtureFileRead = function (json) {
        var filename = json.File;
        if (filename.endsWith("flash/dmx/fixtures/fixtures.json")) {
            var fileContent = Base64.decode(json.Data);
            console.log(fileContent);
            var fixtureJson = JSON.parse(fileContent);
            _this.Config.Fixtures = fixtureJson.Fixtures;
            _this.SavedConfig = angular.copy(_this.Config);
            $rootScope.$apply();

            if (_this.EditDialog) {
                _this.EditDialog.modal('hide');
                _this.EditDialog = null;
            }

            if (_this.$scope && _this.$scope.CancelDialog) {
                _this.$scope.CancelDialog.modal('hide');
                _this.$scope.CancelDialog = null;
            }
        }
    };


    _this.save = function ($scope) {
        for (var fixtureIndex = 0; fixtureIndex < _this.Config.Fixtures.length; fixtureIndex++) {
            var fixture = _this.Config.Fixtures[fixtureIndex];
            if (fixture.Removed) {
                _this.Config.Fixtures.splice(fixtureIndex, 1);
                fixtureIndex--;
            }
        }

        _this.$scope = $scope;
        var jsonString = JSON.stringify({ Fixtures: _this.Config.Fixtures }, function (key, value) {
            console.log("stringify: " + key + ", " + value);
            if (key.startsWith("Added")) return undefined;
            if (key.startsWith("Old")) return undefined;
            if (key.startsWith("Removed")) return undefined;
            else return value;
        }, 2);
        JnrWebsocket.writeFile("/flash/dmx/fixtures/fixtures.json", jsonString).then(_this.writeFileComplete);
    };


    _this.writeFileComplete = function (json) {
        var filename = json.File;
        if ("/flash/dmx/fixtures/fixtures.json" === filename) {
            for (var fixtureIndex = 0; fixtureIndex < _this.Config.Fixtures.length; fixtureIndex++) {
                var fixture = _this.Config.Fixtures[fixtureIndex];
                fixture.OldName = undefined;
                fixture.OldFixtureTypeId = undefined;
                fixture.OldStartChannel = undefined;
                fixture.Added = undefined;
                fixture.Removed = undefined;
            }

            _this.SavedConfig = angular.copy(_this.Config);
            $rootScope.$apply();

            if (_this.$scope && _this.$scope.SaveDialog) {
                _this.$scope.SaveDialog.modal('hide');
                _this.$scope.SaveDialog = null;
            }
        }
    };
});