DmxApp.controller('TriggerController', function ($scope, TriggerService) {
    var _this = this;


    _this.getInputTriggers = function () {
        return TriggerService.Config.InputTriggers;
    };


    _this.getOutputTriggers = function () {
        return TriggerService.Config.OutputTriggers;
    };


    _this.hasInputTriggerChanged = function (channel) {
        return TriggerService.hasInputTriggerChanged(channel);
    };


    _this.hasOutputTriggerChanged = function (channel) {
        return TriggerService.hasOutputTriggerChanged(channel);
    };


    _this.save = function () {
        FixtureService.save();
    };
});



DmxApp.service('TriggerService', function ($rootScope) {
    var _this = this;
    _this.Config = {};
    _this.Config.InputTriggers = [];
    _this.Config.OutputTriggers = [];
    _this.SavedConfig = angular.copy(_this.Config);


    _this.hasChanged = function () {
        var hasChanged = !angular.equals(_this.Config, _this.SavedConfig);
        return hasChanged;
    };


    _this.hasInputTriggerChanged = function (channel) {
        if (channel <= _this.Config.InputTriggers.length) {
            if (null === _this.Config.InputTriggers[channel - 1]) {
                _this.Config.InputTriggers[channel - 1] = "";
            }
            if (null === _this.SavedConfig.InputTriggers[channel - 1]) {
                _this.SavedConfig.InputTriggers[channel - 1] = "";
            }
            return (_this.Config.InputTriggers[channel - 1] !== _this.SavedConfig.InputTriggers[channel - 1]);
        }
        return false;
    };


    _this.hasOutputTriggerChanged = function (channel) {
        if (channel <= _this.Config.OutputTriggers.length) {
            if (null === _this.Config.OutputTriggers[channel - 1]) {
                _this.Config.OutputTriggers[channel - 1] = "";
            }
            if (null === _this.SavedConfig.OutputTriggers[channel - 1]) {
                _this.SavedConfig.OutputTriggers[channel - 1] = "";
            }
            return (_this.Config.OutputTriggers[channel - 1] !== _this.SavedConfig.OutputTriggers[channel - 1]);
        }
        return false;
    };


    _this.load = function ($scope) {
        _this.$scope = $scope;
        JnrWebsocket.readFile("/flash/dmx/triggers.json").then(_this.triggerFileRead);
    };


    _this.triggerFileRead = function (json) {
        var filename = json.File;
        if (filename.endsWith("flash/dmx/triggers.json")) {
            var fileContent = Base64.decode(json.Data);
            console.log(fileContent);
            _this.Config = JSON.parse(fileContent).Triggers;
            _this.SavedConfig = angular.copy(_this.Config);
            $rootScope.$apply();

            if (_this.EditDialog) {
                _this.EditDialog.modal('hide');
                _this.EditDialog = null;
            }

            if (_this.$scope && _this.$scope.CancelDialog) {
                _this.$scope.CancelDialog.modal('hide');
                _this.$scope.CancelDialog = null;
            }
        }
    };


    _this.save = function ($scope) {
        _this.$scope = $scope;
        var jsonString = JSON.stringify({ Triggers: _this.Config }, null, 2);
        JnrWebsocket.writeFile("/flash/dmx/triggers.json", jsonString).then(_this.writeFileComplete);
    };


    _this.writeFileComplete = function (json) {
        var filename = json.File;
        if ("/flash/dmx/triggers.json" === filename) {
            JnrWebsocket.postMessage(1401, JSON.stringify({
                Command: "update-triggers",
                ScriptName: filename
            }));

            _this.SavedConfig = angular.copy(_this.Config);
            $rootScope.$apply();

            if (_this.$scope && _this.$scope.SaveDialog) {
                _this.$scope.SaveDialog.modal('hide');
                _this.$scope.SaveDialog = null;
            }
        }
    };
});