/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx;

import com.integpg.dmx.Config;
import com.integpg.dmx.DmxDimmer;
import com.integpg.sensor.SensorPort;
import com.integpg.system.ArrayUtils;
import java.io.IOException;

public class DmxDimmers {
    private static final SensorPort _sensorPort = new SensorPort();
    private static final byte[] _sensorPortRaw = new byte[17];

    public static void updateDimmers(final byte[] dmxChannels) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SensorPort sensorPort = _sensorPort;
                synchronized (sensorPort) {
                    try {
                        for (DmxDimmer dmxDimmer : Config.getDmxDimmers()) {
                            if (-1 == dmxDimmer.StartAddress || !dmxDimmer.Dirty) continue;
                            DmxDimmers.writeToDimmer(dmxDimmer, dmxChannels);
                        }
                        _sensorPortRaw[0] = -31;
                        _sensorPortRaw[1] = -52;
                        _sensorPortRaw[2] = -106;
                        _sensorPort.open();
                        _sensorPort.reset();
                        _sensorPort.data(_sensorPortRaw, 0, 3);
                        _sensorPort.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        try {
                            _sensorPort.close();
                        }
                        catch (Exception ex1) {
                            ex1.printStackTrace();
                        }
                    }
                }
            }
        }).start();
    }

    private static void writeToDimmer(DmxDimmer dmxDimmer, byte[] dmxChannels) throws IOException {
        dmxDimmer.Dirty = false;
        ArrayUtils.setShort((byte[])_sensorPortRaw, (int)1, (short)ArrayUtils.swapEndian((short)((short)((double)(dmxChannels[dmxDimmer.StartAddress - 1] & 0xFF) / 255.0 * 65534.0 + 1.0))));
        ArrayUtils.setShort((byte[])_sensorPortRaw, (int)3, (short)ArrayUtils.swapEndian((short)((short)((double)(dmxChannels[dmxDimmer.StartAddress] & 0xFF) / 255.0 * 65534.0 + 1.0))));
        ArrayUtils.setShort((byte[])_sensorPortRaw, (int)5, (short)ArrayUtils.swapEndian((short)((short)((double)(dmxChannels[dmxDimmer.StartAddress + 1] & 0xFF) / 255.0 * 65534.0 + 1.0))));
        ArrayUtils.setShort((byte[])_sensorPortRaw, (int)11, (short)ArrayUtils.swapEndian((short)((short)((dmxChannels[dmxDimmer.StartAddress + 2] & 0xFF) * 10 + 1))));
        ArrayUtils.setShort((byte[])_sensorPortRaw, (int)13, (short)ArrayUtils.swapEndian((short)((short)((dmxChannels[dmxDimmer.StartAddress + 3] & 0xFF) * 10 + 1))));
        ArrayUtils.setShort((byte[])_sensorPortRaw, (int)15, (short)ArrayUtils.swapEndian((short)((short)((dmxChannels[dmxDimmer.StartAddress + 4] & 0xFF) * 10 + 1))));
        DmxDimmers._sensorPortRaw[0] = 90;
        _sensorPort.open();
        _sensorPort.select(dmxDimmer.TypeF9.Address);
        _sensorPort.data(_sensorPortRaw, 0, _sensorPortRaw.length);
        _sensorPort.close();
    }
}

