/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx.effects;

import com.integpg.dmx.effects.Effect;

public class EffectExecutor
implements Runnable {
    private final Effect[] _effects = new Effect[32];
    private int maxIndexUsed = -1;

    public void start() {
        Thread thd = new Thread(this);
        thd.setName("Effects");
        thd.setDaemon(true);
        thd.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEffect(Effect effect) {
        Effect[] effectArray = this._effects;
        synchronized (this._effects) {
            for (int i = 0; i < this._effects.length; ++i) {
                if (null != this._effects[i]) continue;
                this._effects[i] = effect;
                if (this.maxIndexUsed >= i) break;
                this.maxIndexUsed = i;
                break;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortEffectFromScript(String scriptName) {
        System.out.println(String.format("abort effects for %s", scriptName));
        Effect[] effectArray = this._effects;
        synchronized (this._effects) {
            for (int i = 0; i < this._effects.length; ++i) {
                if (null == this._effects[i]) continue;
                String parentScriptName = this._effects[i].getParentScriptName();
                System.out.println(String.format("%s parent script is %s", this._effects[i].toString(), parentScriptName));
                boolean isEffectOwnedByScript = scriptName.equals(parentScriptName);
                System.out.println(String.format("%s owned by %s? %s", this._effects[i].toString(), parentScriptName, String.valueOf(isEffectOwnedByScript)));
                if (!isEffectOwnedByScript) continue;
                this._effects[i].abort();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Effect[] effectArray = this._effects;
                    // MONITORENTER : this._effects
                    for (int i = 0; i <= this.maxIndexUsed; ++i) {
                        Effect effect = this._effects[i];
                        if (null == effect) continue;
                        effect.update();
                        if (!effect.isComplete()) continue;
                        this._effects[i] = null;
                        if (this.maxIndexUsed != i) continue;
                        --this.maxIndexUsed;
                    }
                    // MONITOREXIT : effectArray
                    Thread.sleep(1L);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }
}

