/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx.scenes;

import com.integpg.dmx.DmxMain;
import com.integpg.dmx.fixtures.Fixture;
import com.integpg.dmx.fixtures.FixtureManager;
import com.integpg.dmx.scenes.Channels;
import com.integpg.dmx.scenes.SceneStep;
import com.integpg.janoslib.logger.AppLog;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.janoslib.utils.FileUtils;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.system.ArrayUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Json;

public class SceneFile {
    private static final QuickDateFormat QDF = new QuickDateFormat("hh:mm:ss.fff");
    public long LastModifiedTime = 0L;
    private final String _filename;
    private final File _file;
    private String _name;
    private int _stepInterval = 100;
    private ArrayList<SceneStep> _steps = new ArrayList();
    private Channels _channels = new Channels();

    public SceneFile(String filename) {
        this._filename = filename;
        this._file = new File(filename);
    }

    public String getFilename() {
        return this._file.getPath();
    }

    public String getName() {
        return this._name;
    }

    public int getInterval() {
        if (0 >= this._stepInterval) {
            this._stepInterval = 100;
        }
        return this._stepInterval;
    }

    public int getStepCount() {
        return this._steps.size();
    }

    public void process() {
        AppLog.info("process scene file: " + this._filename);
        this.LastModifiedTime = this._file.lastModified();
        try {
            if (this._filename.endsWith(".scene")) {
                this._name = this._file.getName().substring(0, this._file.getName().lastIndexOf("."));
            } else if (this._filename.endsWith(".json")) {
                this.processJson();
            }
            AppLog.info("loaded " + this._filename);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void processBinary() throws IOException {
        byte[] fileBytes = FileUtils.readAllBytes(this._filename);
        SceneStep sceneStep = new SceneStep();
        sceneStep.ChannelOffset = ArrayUtils.getShort((byte[])fileBytes, (int)0);
        short channelMaskLength = ArrayUtils.getShort((byte[])fileBytes, (int)2);
        sceneStep.ChannelMask = new byte[64];
        ArrayUtils.arraycopy((Object)fileBytes, (int)4, (Object)sceneStep.ChannelMask, (int)((sceneStep.ChannelOffset - 1) / 8), (int)channelMaskLength);
        short channelStatesLength = ArrayUtils.getShort((byte[])fileBytes, (int)(4 + channelMaskLength));
        sceneStep.ChannelValues = new byte[channelStatesLength];
        ArrayUtils.arraycopy((Object)fileBytes, (int)(6 + channelMaskLength), (Object)sceneStep.ChannelValues, (int)0, (int)channelStatesLength);
    }

    private void processJson() throws IOException {
        String fileContent = FileUtils.readAllText(this._filename);
        Json fileJson = new Json(fileContent);
        Json sceneJson = (Json)fileJson.get("scene");
        if (null != sceneJson) {
            Json[] stepsArray;
            this._name = sceneJson.getString("name");
            System.out.println("Scene Name: " + this._name);
            if (sceneJson.containsKey("stepInterval")) {
                this._stepInterval = sceneJson.getInt("stepInterval");
            }
            if (null != (stepsArray = (Json[])sceneJson.get("steps"))) {
                this._channels = new Channels();
                for (Json stepJson : stepsArray) {
                    Json[] channelsArray;
                    Json[] fixturesArray = (Json[])stepJson.get("fixtures");
                    if (null != fixturesArray) {
                        for (Json fixtureJson : fixturesArray) {
                            int fixtureId = fixtureJson.getInt("id");
                            Fixture fixture = FixtureManager.getById(fixtureId);
                            if (null != fixture) {
                                Json[] channelsArray2 = (Json[])fixtureJson.get("channels");
                                if (null == channelsArray2) continue;
                                for (Json channelJson : channelsArray2) {
                                    int index = channelJson.getInt("index");
                                    this.processChannelsJson(channelJson, fixture.getStartChannel() + index - 1);
                                }
                                continue;
                            }
                            System.out.println("fixture was null for id: " + fixtureId);
                        }
                    }
                    if (null != (channelsArray = (Json[])stepJson.get("channels"))) {
                        for (Json channelJson : channelsArray) {
                            int startChannel;
                            if (channelJson.containsKey("channel")) {
                                startChannel = channelJson.getInt("channel");
                                this.processChannelsJson(channelJson, startChannel);
                                continue;
                            }
                            if (!channelJson.containsKey("StartChannel")) continue;
                            startChannel = channelJson.getInt("StartChannel");
                            int endChannel = channelJson.getInt("EndChannel");
                            int value = channelJson.getInt("Value");
                            while (startChannel <= endChannel) {
                                this._channels.setChannel(startChannel++, value);
                            }
                        }
                    }
                    SceneStep sceneStep = new SceneStep();
                    sceneStep.ChannelOffset = this._channels.getStartChannel();
                    sceneStep.ChannelMask = new byte[64];
                    byte[] channelMask = this._channels.getChannelMask();
                    ArrayUtils.arraycopy((Object)channelMask, (int)0, (Object)sceneStep.ChannelMask, (int)((sceneStep.ChannelOffset - 1) / 8), (int)channelMask.length);
                    sceneStep.ChannelValues = this._channels.getChannelValues();
                    this._steps.add(sceneStep);
                    System.out.println("channelOffset: " + sceneStep.ChannelOffset);
                    System.out.println("channelMask:\r\n" + HexUtils.hexDump(sceneStep.ChannelMask));
                    System.out.println("channelStates:\r\n" + HexUtils.hexDump(sceneStep.ChannelValues));
                }
            }
        }
    }

    public void execute() throws InterruptedException {
        for (int i = 0; i < this._steps.size(); ++i) {
            this.executeStep(i);
            if (i >= this._steps.size() - 1) continue;
            Thread.sleep(this._stepInterval);
        }
    }

    public void executeStep(int stepIndex) {
        System.out.println("execute step " + stepIndex + " for " + this.getName());
        SceneStep sceneStep = this._steps.get(stepIndex);
        DmxMain.DMX_PORTS[0].setChannels(sceneStep.ChannelOffset, sceneStep.ChannelValues, sceneStep.ChannelMask);
    }

    private void processChannelsJson(Json channelJson, int startIndex) {
        if (channelJson.containsKey("Value")) {
            int value = channelJson.getInt("Value");
            this._channels.setChannel(startIndex, value);
        } else if (channelJson.containsKey("Values")) {
            Object[] values;
            for (Object value : values = (Object[])channelJson.get("Values")) {
                this._channels.setChannel(startIndex, Integer.parseInt(value.toString()));
                ++startIndex;
            }
        }
    }
}

