/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx.effects;

import com.integpg.dmx.effects.Effect;

public class EffectExecutor
implements Runnable {
    private final Effect[] _effects = new Effect[32];
    private int _maxIndexUsed = -1;
    private boolean _aborting = false;

    public void start() {
        Thread thd = new Thread(this);
        thd.setName("Effects");
        thd.setDaemon(true);
        thd.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEffect(Effect effect) {
        Effect[] effectArray = this._effects;
        synchronized (this._effects) {
            for (int i = 0; i < this._effects.length; ++i) {
                if (null != this._effects[i]) continue;
                this._effects[i] = effect;
                if (this._maxIndexUsed >= i) break;
                this._maxIndexUsed = i;
                break;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortEffectFromScript(String scriptName) {
        System.out.println(String.format("abort effects for %s", scriptName));
        this._aborting = true;
        Effect[] effectArray = this._effects;
        synchronized (this._effects) {
            for (int i = 0; i < this._effects.length; ++i) {
                String parentScriptName;
                boolean isEffectOwnedByScript;
                if (null == this._effects[i] || !(isEffectOwnedByScript = scriptName.equals(parentScriptName = this._effects[i].getParentScriptName()))) continue;
                this._effects[i].abort();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortEffectsNotFromScript(String scriptName) {
        System.out.println(String.format("abort effects not from %s", scriptName));
        this._aborting = true;
        Effect[] effectArray = this._effects;
        synchronized (this._effects) {
            for (int i = 0; i < this._effects.length; ++i) {
                String parentScriptName;
                boolean isEffectOwnedByScript;
                if (null == this._effects[i] || (isEffectOwnedByScript = scriptName.equals(parentScriptName = this._effects[i].getParentScriptName()))) continue;
                this._effects[i].abort();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scriptHasRunningEffect(String scriptName) {
        Effect[] effectArray = this._effects;
        synchronized (this._effects) {
            for (int i = 0; i < this._effects.length; ++i) {
                String parentScriptName;
                boolean isEffectOwnedByScript;
                if (null == this._effects[i] || !(isEffectOwnedByScript = scriptName.equals(parentScriptName = this._effects[i].getParentScriptName()))) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Effect[] effectArray = this._effects;
                    // MONITORENTER : this._effects
                    for (int i = 0; i <= this._maxIndexUsed; ++i) {
                        Effect effect = this._effects[i];
                        if (null != effect) {
                            if (effect.isComplete()) {
                                this._effects[i] = null;
                            } else {
                                effect.update();
                            }
                        }
                        if (null != this._effects[i] || this._maxIndexUsed != i) continue;
                        System.out.println("remove effect at " + i);
                        --this._maxIndexUsed;
                        System.out.println(String.format("max %d effects used", this._maxIndexUsed));
                    }
                    // MONITOREXIT : effectArray
                    Thread.sleep(1L);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }
}

