/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx.effects;

import com.integpg.dmx.DmxMain;
import com.integpg.dmx.effects.Effect;
import com.integpg.janoslib.logging.AppLog;

public class ExponentialFadeEffect
extends Effect {
    private long _lastUpdate = 0L;
    private final int[] _channels;
    private final int[] _initialValues;
    private final int[] _newValues;
    private final int[] _channelDelta;
    private final byte[] _bytes;
    private final boolean[] _decending;
    private final int[] _lastValue;
    private final int _duration;
    private final boolean _repeat = false;
    private final long _startTime;
    private int _updates = 0;
    private int _minChannel = 512;
    private boolean _sequential = true;
    private byte[] _channelMask = new byte[64];

    public ExponentialFadeEffect(int[] channels, int[] newValues, int duration) {
        this._channels = channels;
        this._newValues = newValues;
        int channelsLength = channels.length;
        int startingChannel = channels[0];
        int channelRange = channels[channels.length - 1] - startingChannel + 1;
        if (channelRange > channelsLength) {
            channelsLength = channelRange;
            this._sequential = false;
            for (int channel : channels) {
                int channelOffset;
                int n = channelOffset = (channel - 1) / 8;
                this._channelMask[n] = (byte)(this._channelMask[n] | (byte)(1 << (channel - 1) % 8));
            }
        }
        this._bytes = new byte[channelsLength];
        this._channelDelta = new int[channelsLength];
        this._decending = new boolean[channelsLength];
        this._lastValue = new int[channelsLength];
        this._duration = duration;
        this._initialValues = new int[newValues.length];
        byte[] dmxChannels = DmxMain.DMX_PORTS[0].getChannels();
        for (int i = 0; i < this._channels.length; ++i) {
            if (this._minChannel > this._channels[i]) {
                this._minChannel = this._channels[i];
            }
            this._initialValues[i] = dmxChannels[channels[i] - 1] & 0xFF;
            this._bytes[i] = (byte)this._initialValues[i];
            this._decending[i] = this._initialValues[i] > newValues[i];
            this._channelDelta[i] = newValues[i] - this._initialValues[i];
        }
        this._startTime = System.currentTimeMillis();
    }

    @Override
    public void update() {
        this._lastUpdate = System.currentTimeMillis();
        long elapsed = this._lastUpdate - this._startTime;
        if (elapsed > (long)this._duration) {
            elapsed = this._duration;
        }
        double ascendingFadePercentage = this.exponentialFade(elapsed);
        double decendingFadePercentage = this.exponentialFade((long)this._duration - elapsed);
        for (int i = 0; i < this._channels.length; ++i) {
            if (0 == this._channelDelta[i]) continue;
            try {
                double channelFadePercentage = this._decending[i] ? decendingFadePercentage : ascendingFadePercentage;
                int channelDelta = (int)Math.ceil(channelFadePercentage * (double)this._channelDelta[i]);
                if (this._decending[i]) {
                    channelDelta = this._channelDelta[i] - channelDelta;
                }
                int value = this._initialValues[i] + channelDelta;
                if (elapsed == (long)this._duration && this._newValues[i] != value) {
                    AppLog.error(String.format("Channel %d not at correct end value: init: %d, new: %d, val %d: %s", this._channels[i], this._initialValues[i], this._newValues[i], value, Thread.currentThread().getName()));
                }
                int channelOffset = this._channels[i] - this._minChannel;
                this._bytes[channelOffset] = (byte)value;
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (512 != this._minChannel) {
            if (this._sequential) {
                DmxMain.DMX_PORTS[0].setChannels(this._minChannel, this._bytes);
            } else {
                DmxMain.DMX_PORTS[0].setChannels(this._minChannel, this._bytes, this._channelMask);
            }
        }
        ++this._updates;
    }

    @Override
    public boolean isComplete() {
        boolean complete;
        if (this._abort) {
            return true;
        }
        long elapsed = this._lastUpdate - this._startTime;
        boolean bl = complete = (long)this._duration < elapsed;
        if (complete) {
            System.out.println(String.format("%d updates", this._updates));
        }
        return complete;
    }

    private double exponentialFade(long elapsed) {
        double value = 1.0;
        if (0 != this._duration) {
            double x = (double)elapsed / (double)this._duration;
            value = Math.pow(x, 2.0);
        }
        return value;
    }
}

