/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx.web;

import com.integpg.dmx.DmxMain;
import com.integpg.dmx.effects.ChaseEffect;
import com.integpg.janoslib.http.server.HttpContext;
import com.integpg.janoslib.http.server.HttpResponse;
import com.integpg.janoslib.http.server.WebHandler;
import com.integpg.janoslib.logger.AppLog;
import com.integpg.janoslib.utils.StringUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class ChaseWebHandler
implements WebHandler {
    @Override
    public void processRequest(HttpContext httpContext) {
        try {
            AppLog.info("Processing " + httpContext.getRequest().getRequestedResource());
            HttpResponse response = httpContext.getResponse();
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            Hashtable<String, String> queryParams = httpContext.getRequest().getQueryParams();
            Enumeration<String> e = queryParams.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                String value = queryParams.get(key);
                out.println(key + " = " + value);
                out.println("<br>");
            }
            out.println("<br>");
            try {
                String sceneNamesString = queryParams.get("sceneNames");
                if (null == sceneNamesString) {
                    throw new Exception("Scene Names expected");
                }
                String[] sceneNames = StringUtils.split(sceneNamesString, ",");
                String durationString = queryParams.get("duration");
                if (null == durationString) {
                    throw new Exception("Duration expected");
                }
                int duration = Integer.valueOf(durationString);
                int repeatCount = 1;
                String repeatCountString = queryParams.get("repeatCount");
                if (null != repeatCountString) {
                    repeatCount = Integer.valueOf(repeatCountString);
                }
                ChaseEffect chaseEffect = new ChaseEffect(sceneNames, duration, repeatCount);
                DmxMain.EFFECTS.addEffect(chaseEffect);
            }
            catch (Exception ex) {
                out.println("error: " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                httpContext.getRequest().close();
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
        }
    }
}

