/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integpg.dmx.ArtNet;
import com.integpg.dmx.AssemblyInfo;
import com.integpg.dmx.ChannelUpdater;
import com.integpg.dmx.Config;
import com.integpg.dmx.DmxCommandLine;
import com.integpg.dmx.DmxPort;
import com.integpg.dmx.JniorProtocolListener;
import com.integpg.dmx.PingHandler;
import com.integpg.dmx.ScriptFile;
import com.integpg.dmx.ScriptFileCollection;
import com.integpg.dmx.TriggerManager;
import com.integpg.dmx.UdpServer;
import com.integpg.dmx.WebPageListener;
import com.integpg.dmx.client.ClientConnection;
import com.integpg.dmx.client.ClientConnectionListener;
import com.integpg.dmx.effects.EffectExecutor;
import com.integpg.dmx.fixtures.FixtureManager;
import com.integpg.dmx.fixtures.FixtureTypeManager;
import com.integpg.dmx.scenes.SceneFile;
import com.integpg.dmx.scenes.SceneManager;
import com.integpg.dmx.web.ChaseWebHandler;
import com.integpg.dmx.web.SceneWebHandler;
import com.integpg.dmx.web.ScriptWebHandler;
import com.integpg.janoslib.http.server.WebHandlerServer;
import com.integpg.janoslib.logger.AppLog;
import com.integpg.janoslib.net.IClient;
import com.integpg.janoslib.net.TcpServer;
import com.integpg.janoslib.net.TcpServerEvent;
import com.integpg.janoslib.net.TcpServerListener;
import com.integpg.janoslib.system.Application;
import com.integpg.system.MessagePump;
import com.integpg.system.SystemMsg;
import java.io.File;
import java.net.Socket;

public class DmxMain
implements Runnable,
TcpServerListener,
ClientConnectionListener {
    private static DmxMain INSTANCE;
    public static final DmxPort[] DMX_PORTS;
    public static final EffectExecutor EFFECTS;
    private MessagePump pump;

    public static void main(String[] args) {
        try {
            Application.init(new AssemblyInfo());
            Application.enableApplicationWatchdog(0);
            INSTANCE = new DmxMain();
            INSTANCE.init(args);
            Application.sleepForever();
        }
        catch (Exception ex) {
            AppLog.fatal(ex.toString());
        }
    }

    public void init(String[] args) throws InterruptedException {
        String[] fileNames;
        Config.init();
        DmxMain.DMX_PORTS[0] = new DmxPort();
        this.startUdpServer();
        this.startTcpServer();
        File dmxDirectory = new File("/flash/dmx");
        AppLog.info(dmxDirectory + " exists: " + dmxDirectory.exists());
        if (!dmxDirectory.exists()) {
            AppLog.info("create " + dmxDirectory);
            dmxDirectory.mkdir();
        }
        File dmxFixturesDirectory = new File("/flash/dmx/fixtures");
        AppLog.info(dmxFixturesDirectory + " exists: " + dmxFixturesDirectory.exists());
        if (!dmxFixturesDirectory.exists()) {
            AppLog.info("create " + dmxFixturesDirectory);
            dmxFixturesDirectory.mkdir();
        }
        File scriptsDirectory = new File("/flash/dmx/scripts");
        AppLog.info(scriptsDirectory + " exists: " + scriptsDirectory.exists());
        if (!scriptsDirectory.exists()) {
            AppLog.info("create " + scriptsDirectory);
            scriptsDirectory.mkdir();
        }
        for (String filename : fileNames = scriptsDirectory.list()) {
            if (!filename.endsWith(".script") || filename.startsWith("~")) continue;
            ScriptFile scriptFile = new ScriptFile("/flash/dmx/scripts/" + filename);
            scriptFile.processFile();
            String scriptName = scriptFile.getFile().getName();
            AppLog.info("scriptName: " + scriptName);
            scriptName = scriptName.substring(0, scriptName.indexOf("."));
            AppLog.info("scriptName: " + scriptName);
            ScriptFileCollection.put(scriptName.toLowerCase(), scriptFile);
        }
        AppLog.info(ScriptFileCollection.size() + " script files");
        FixtureTypeManager.loadFixtureTypes();
        FixtureManager.loadFixtures();
        SceneManager.loadScenes();
        SceneFile[] sceneFiles = SceneManager.getScenes();
        System.out.println("execute all off scene");
        SceneManager.executeScene("all-off");
        TriggerManager.load();
        Thread thd = new Thread(this);
        thd.setName("Panel");
        thd.start();
        MessagePumpEngine.start();
        MessagePumpEngine.addListener(new PingHandler());
        MessagePumpEngine.addListener(new WebPageListener());
        MessagePumpEngine.addListener(new JniorProtocolListener());
        MessagePumpEngine.start();
        ChannelUpdater channelUpdater = new ChannelUpdater();
        channelUpdater.start();
        this.initWebServer();
        EFFECTS.start();
    }

    private void startUdpServer() {
        UdpServer udpServer = new UdpServer(6454);
        udpServer.setListener(new ArtNet());
        udpServer.start();
    }

    private void startTcpServer() {
        Config.getTerminationBytes();
        int tcpServerPort = Config.getTcpServerPort();
        TcpServer tcpServer = new TcpServer("Tcp Server", tcpServerPort);
        tcpServer.setTcpServerListener(this);
        tcpServer.start();
    }

    @Override
    public void clientConnected(TcpServerEvent evt) {
        Socket socket = evt.getSocket();
        ClientConnection clientConnection = new ClientConnection(socket);
        clientConnection.setListener(this);
        Thread thd = new Thread(clientConnection);
        thd.setDaemon(true);
        thd.start();
    }

    @Override
    public void processMessage(IClient client, String message) {
        System.out.println("processMessage = " + message);
        DmxCommandLine.process(client, message);
    }

    @Override
    public void run() {
        this.pump = new MessagePump();
        this.pump.open();
        while (true) {
            try {
                while (true) {
                    SystemMsg systemMsg = this.pump.getMessage(1400);
                    this.pump.postMessage(systemMsg);
                    String text = new String(systemMsg.msg);
                    int pos = text.indexOf(",");
                    if (-1 == pos) continue;
                    String sliderChannelString = text.substring(0, pos);
                    int val = Integer.parseInt(text.substring(pos + 1));
                    System.out.println("sliderChannelString: " + sliderChannelString);
                    int chan = Integer.parseInt(sliderChannelString);
                    System.out.println("chan: " + chan);
                    if (chan <= 0 || chan > 512) continue;
                    DMX_PORTS[0].setChannel(chan, (byte)val);
                }
            }
            catch (Exception ex) {
                AppLog.error(ex);
                continue;
            }
            break;
        }
    }

    private void initWebServer() {
        WebHandlerServer webHandlerServer = new WebHandlerServer();
        webHandlerServer.addWebHandler("/chase", new ChaseWebHandler());
        webHandlerServer.addWebHandler("/scene", new SceneWebHandler());
        webHandlerServer.addWebHandler("/script", new ScriptWebHandler());
        int webServerPort = Config.getWebServerPort();
        webHandlerServer.start(webServerPort);
    }

    static {
        DMX_PORTS = new DmxPort[1];
        EFFECTS = new EffectExecutor();
    }
}

