/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.threading;

import com.integpg.janoslib.logger.AppLog;
import com.integpg.janoslib.threading.ThreadPool;

public class ThreadWorker
extends Thread {
    private Runnable _task;
    private boolean _cancel = false;
    private boolean _done = false;

    public ThreadWorker() {
        this.setDaemon(true);
    }

    public ThreadWorker(String name) {
        super(name);
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTask(Runnable task) {
        ThreadWorker threadWorker = this;
        synchronized (threadWorker) {
            this._task = task;
            this.notifyAll();
            Thread.yield();
        }
    }

    public boolean isBusy() {
        return this._task != null;
    }

    public boolean isDone() {
        return this._done;
    }

    public void cancel() {
        this._cancel = true;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this._cancel) {
            ThreadWorker threadWorker = this;
            synchronized (threadWorker) {
                block8: {
                    if (this._task == null) {
                        try {
                            long beforeWaitTime = System.currentTimeMillis();
                            this.wait(300000L);
                            long elapsedWait = System.currentTimeMillis() - beforeWaitTime;
                            if (300000L <= elapsedWait) {
                                break;
                            }
                        }
                        catch (InterruptedException ex) {
                            if (this._cancel) break block8;
                            AppLog.error("Error executing ThreadWorker", ex);
                        }
                    }
                }
            }
            if (this._task == null) continue;
            this._task.run();
            this._task = null;
            ThreadPool.threadWorkerAvailable(this);
        }
        ThreadPool.LOG.warn(this.getName() + " is done.");
        AppLog.warn(this.getName() + " is done.");
        this._done = true;
    }
}

