/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx;

import com.integpg.dmx.actions.AdjustChannelCommand;
import com.integpg.dmx.actions.At;
import com.integpg.dmx.actions.DelayCommand;
import com.integpg.dmx.actions.DelayMillisCommand;
import com.integpg.dmx.actions.FadeChannelCommand;
import com.integpg.dmx.actions.SceneCommand;
import com.integpg.dmx.actions.SetChannelCommand;
import com.integpg.dmx.actions.TestCommand;
import com.integpg.janoslib.logger.AppLog;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.janoslib.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class ScriptFile {
    private static final QuickDateFormat QDF = new QuickDateFormat("hh:mm:ss.fff");
    public long LastModifiedTime = 0L;
    private final String _filename;
    private final File _file;
    private final ArrayList<At> _atCommands = new ArrayList();
    private At _processorAt;
    private At _executingAt;
    private boolean _shouldAbort = false;

    public ScriptFile(String filename) {
        this._filename = filename;
        this._file = new File(filename);
    }

    public void execute() throws InterruptedException {
        this._shouldAbort = false;
        try {
            AppLog.info("executing " + this._filename + " loaded at " + QDF.format(this.LastModifiedTime));
            long startTime = System.currentTimeMillis();
            System.out.println("Start At commands at " + QDF.format(System.currentTimeMillis()));
            System.out.println("_atCommands.size(): " + this._atCommands.size());
            for (int i = 0; i < this._atCommands.size(); ++i) {
                if (this._shouldAbort) {
                    throw new InterruptedException("user aborted");
                }
                this._executingAt = this._atCommands.get(i);
                this._executingAt.execute(startTime);
            }
        }
        catch (InterruptedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            AppLog.error(ex);
        }
    }

    public void abort() {
        this._shouldAbort = true;
        if (null != this._executingAt) {
            this._executingAt.abort();
        }
    }

    public void processFile() {
        try {
            AppLog.info("loading " + this._filename);
            this.LastModifiedTime = this._file.lastModified();
            byte[] fileBytes = FileUtils.readAllBytes(this._filename);
            String fileContentString = new String(fileBytes);
            this.processFileContents(fileContentString);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        for (int i = 0; i < this._atCommands.size(); ++i) {
            At at = this._atCommands.get(i);
            at.commit();
        }
        AppLog.info("loaded " + this._filename);
    }

    private void processFileContents(String fileContentString) {
        int pos = 0;
        int fileLength = fileContentString.length();
        while (pos < fileLength) {
            int found;
            int endOfLine = fileContentString.indexOf("\n", pos);
            if (-1 == endOfLine) {
                endOfLine = fileLength;
            }
            if (endOfLine > pos && pos < (found = fileContentString.indexOf("(", pos))) {
                String methodName = fileContentString.substring(pos, found).trim();
                pos = found + 1;
                if (pos <= (found = fileContentString.indexOf(")", pos))) {
                    String parameters = fileContentString.substring(pos, found).trim();
                    pos = found + 1;
                    this.callMethod(methodName, parameters);
                }
            }
            pos = endOfLine + 1;
        }
    }

    private void callMethod(String methodName, String parameters) {
        if ("@".equals(methodName)) {
            if (null != this._processorAt) {
                this._atCommands.add(this._processorAt);
            }
            double atTimeInSeconds = Double.valueOf(parameters);
            this._processorAt = new At((long)(atTimeInSeconds * 1000.0));
            this._atCommands.add(this._processorAt);
        } else {
            if (null == this._processorAt) {
                this._processorAt = new At(0L);
                this._atCommands.add(this._processorAt);
            }
            try {
                if ("scene".equalsIgnoreCase(methodName)) {
                    SceneCommand sceneCommand = new SceneCommand(parameters);
                    this._processorAt.Commands.add(sceneCommand);
                } else if ("delay".equalsIgnoreCase(methodName)) {
                    DelayCommand delayCommand = new DelayCommand(parameters);
                    this._processorAt.Commands.add(delayCommand);
                } else if ("delaymillis".equalsIgnoreCase(methodName)) {
                    DelayMillisCommand delayMillisCommand = new DelayMillisCommand(parameters);
                    this._processorAt.Commands.add(delayMillisCommand);
                } else if ("set".equalsIgnoreCase(methodName)) {
                    SetChannelCommand channelCommand = new SetChannelCommand(parameters);
                    this._processorAt.Commands.add(channelCommand);
                } else if ("adjust".equalsIgnoreCase(methodName)) {
                    AdjustChannelCommand channelCommand = new AdjustChannelCommand(parameters);
                    this._processorAt.Commands.add(channelCommand);
                } else if ("fade".equalsIgnoreCase(methodName)) {
                    FadeChannelCommand fadeChannelCommand = new FadeChannelCommand(this._filename, parameters);
                    this._processorAt.Commands.add(fadeChannelCommand);
                } else if ("test".equalsIgnoreCase(methodName)) {
                    TestCommand testCommand = new TestCommand(parameters);
                    System.out.println("add " + testCommand);
                    this._processorAt.Commands.add(testCommand);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public String getFilename() {
        return this._filename;
    }

    public File getFile() {
        return this._file;
    }
}

