/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.threading;

import com.integpg.janoslib.collections.Queue;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.logging.Logger;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.threading.ThreadWorker;
import com.integpg.system.ArrayUtils;

public class ThreadPool {
    public static final Logger LOG = Logger.getLogger("/temp/threadpool.log");
    private static final Object THREAD_POOL_LOCK = new Object();
    private static final int THREAD_POOL_SIZE = 10;
    private static ThreadWorker[] _threadPool = new ThreadWorker[10];
    private static final Queue _tasks = new Queue();
    private static int _threadWorkerCount = 0;
    private static boolean _cancelled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean execute(Runnable task) {
        ThreadWorker threadWorker = null;
        Object object = THREAD_POOL_LOCK;
        synchronized (object) {
            if (_cancelled) {
                throw new RuntimeException("ThreadPool has been cancelled");
            }
            boolean nullified = false;
            for (int i = 0; i < _threadWorkerCount; ++i) {
                if (null == _threadPool[i]) continue;
                if (_threadPool[i].isDone()) {
                    String s = String.format("nullify %s", _threadPool[i].getName());
                    LOG.info(s);
                    ArrayUtils.arraycopy((Object)_threadPool, (int)(i + 1), (Object)_threadPool, (int)i, (int)(_threadWorkerCount - i));
                    ThreadPool._threadPool[ThreadPool._threadWorkerCount - 1] = null;
                    --_threadWorkerCount;
                    --i;
                    nullified = true;
                    continue;
                }
                if (_threadPool[i].isBusy()) continue;
                threadWorker = _threadPool[i];
                break;
            }
            if (nullified) {
                for (int j = 0; j < _threadWorkerCount; ++j) {
                    LOG.info(String.format("%d: %s", j, _threadPool[j] != null ? _threadPool[j].toString() : "null"));
                }
            }
            if (threadWorker == null && _threadWorkerCount < 10) {
                threadWorker = new ThreadWorker(_threadWorkerCount);
                threadWorker.start();
                ThreadPool._threadPool[ThreadPool._threadWorkerCount++] = threadWorker;
                String s = String.format("%d: %s has started", _threadWorkerCount - 1, threadWorker.getName());
                AppLog.info(s);
                LOG.info(s);
                for (int j = 0; j < _threadWorkerCount; ++j) {
                    LOG.info(String.format("%d: %s", j, _threadPool[j] != null ? _threadPool[j].toString() : "null"));
                }
            }
        }
        if (threadWorker != null) {
            threadWorker.setTask(task);
            return true;
        }
        String s = String.format("[%s] no ThreadWorker available.  queue %s task", Application.getAppName(), task.toString());
        AppLog.info(s);
        LOG.info(s);
        Queue queue = _tasks;
        synchronized (queue) {
            _tasks.enqueue(task);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void threadWorkerAvailable(ThreadWorker threadWorker) {
        Runnable r = null;
        Queue queue = _tasks;
        synchronized (queue) {
            if (!_tasks.isEmpty()) {
                r = (Runnable)_tasks.dequeue();
            }
        }
        if (r != null) {
            LOG.info(String.format("[%s] execute queued task: %s", Application.getAppName(), threadWorker.getName()));
            threadWorker.setTask(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancel() {
        Object object = THREAD_POOL_LOCK;
        synchronized (object) {
            _cancelled = true;
            Queue queue = _tasks;
            synchronized (queue) {
                while (!_tasks.isEmpty()) {
                    _tasks.dequeue();
                }
            }
            for (int i = 0; i < _threadWorkerCount; ++i) {
                _threadPool[i].cancel();
            }
        }
    }

    public static void setThreadWorkerLimit(int limit) {
        ThreadPool.cancel();
        _threadPool = new ThreadWorker[limit];
        _cancelled = false;
    }
}

