/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx;

import com.integpg.dmx.DmxMain;
import com.integpg.dmx.ScriptFile;
import com.integpg.janoslib.logging.Logger;
import com.integpg.janoslib.system.Application;
import java.util.Enumeration;
import java.util.Hashtable;

public class ScriptExecutor
implements Runnable {
    private static final Logger LOG = Logger.getLogger(Application.getAppName() + "_script_executor.log");
    private static final Hashtable<String, ScriptExecutor> _executingScripts = new Hashtable();
    private final ScriptFile _scriptFile;
    private final String _fullScriptName;
    private final String _scriptName;
    private Thread _thread;
    private int _repeatCount = 1;

    public ScriptExecutor(ScriptFile scriptFile) {
        this._scriptFile = scriptFile;
        this._fullScriptName = scriptFile.getFile().getPath();
        String scriptName = scriptFile.getFile().getName();
        if (scriptName.contains(".")) {
            scriptName = scriptName.substring(0, scriptName.indexOf("."));
        }
        this._scriptName = scriptName.toLowerCase();
    }

    public void start() {
        this._thread = new Thread(this);
        this._thread.setName("ScriptExecutor:" + this._scriptFile.getFilename());
        this._thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isScriptExecuting(String scriptName) {
        Hashtable<String, ScriptExecutor> hashtable = _executingScripts;
        synchronized (hashtable) {
            return _executingScripts.containsKey(scriptName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScriptExecutor getByName(String scriptName) {
        Hashtable<String, ScriptExecutor> hashtable = _executingScripts;
        synchronized (hashtable) {
            return _executingScripts.get(scriptName);
        }
    }

    public void setRepeatCount(int repeatCount) {
        this._repeatCount = repeatCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Hashtable<String, ScriptExecutor> hashtable;
        try {
            hashtable = _executingScripts;
            synchronized (hashtable) {
                _executingScripts.put(this._scriptName, this);
            }
            if (-1 == this._repeatCount) {
                LOG.info(this._scriptName + " execute forever");
            }
            do {
                if (0 < this._repeatCount) {
                    --this._repeatCount;
                    LOG.info(this._scriptName + ": " + this._repeatCount + " executions remaining");
                }
                System.out.println("_repeatCount = " + this._repeatCount);
                this._scriptFile.execute();
            } while (this._repeatCount > 0 || -1 == this._repeatCount);
            LOG.info(String.format("execution completed for %s", this._scriptName));
        }
        catch (InterruptedException ex) {
            LOG.info(this._scriptFile.getFilename() + " aborted");
        }
        hashtable = _executingScripts;
        synchronized (hashtable) {
            _executingScripts.remove(this._scriptName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void abortAll() {
        Hashtable<String, ScriptExecutor> hashtable = _executingScripts;
        synchronized (hashtable) {
            Enumeration<ScriptExecutor> e = _executingScripts.elements();
            while (e.hasMoreElements()) {
                ScriptExecutor scriptExecutor = e.nextElement();
                scriptExecutor.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void abortAllExcept(String scriptName) {
        LOG.info(String.format("aborting all other scripts except %s", scriptName));
        Hashtable<String, ScriptExecutor> hashtable = _executingScripts;
        synchronized (hashtable) {
            Enumeration<ScriptExecutor> e = _executingScripts.elements();
            while (e.hasMoreElements()) {
                ScriptExecutor scriptExecutor = e.nextElement();
                if (scriptExecutor._fullScriptName.equalsIgnoreCase(scriptName)) continue;
                scriptExecutor.abort();
                DmxMain.EFFECTS.abortEffectsNotFromScript(scriptName);
            }
        }
        while (1 < _executingScripts.size()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        LOG.info(String.format("aborting all other scripts except %s has completed", scriptName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void abort(String scriptName) {
        Hashtable<String, ScriptExecutor> hashtable = _executingScripts;
        synchronized (hashtable) {
            if (_executingScripts.containsKey(scriptName)) {
                ScriptExecutor scriptExecutor = _executingScripts.get(scriptName);
                scriptExecutor.abort();
            }
        }
    }

    private void abort() {
        LOG.info("aborting " + this._scriptFile.getFilename());
        this._repeatCount = 0;
        this._scriptFile.abort();
    }
}

