/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.http.server;

import com.integpg.janoslib.http.HttpConnection;
import com.integpg.janoslib.http.server.HttpListener;
import com.integpg.janoslib.http.server.HttpRequest;
import com.integpg.janoslib.http.server.HttpServer;
import java.net.Socket;

class AcceptHttpConnection
implements Runnable {
    private final HttpServer _httpServer;
    private final Socket _socket;

    public AcceptHttpConnection(HttpServer httpServer, Socket socket) {
        this._httpServer = httpServer;
        this._socket = socket;
    }

    @Override
    public void run() {
        try {
            long start = System.currentTimeMillis();
            String hostAddress = this._socket.getInetAddress().getHostAddress();
            HttpConnection httpConnection = new HttpConnection(this._httpServer, this._socket);
            HttpRequest httpRequest = new HttpRequest(httpConnection);
            httpRequest.processRequest();
            if (null != httpRequest.getRequest()) {
                if (null == httpRequest.getRequestedResource()) {
                    HttpServer.WebServerLog.warn("Missing requested resource");
                    this._httpServer.blocklistHostAddress(hostAddress);
                    httpConnection.close();
                } else {
                    for (int i = 0; i < this._httpServer.getListeners().size(); ++i) {
                        HttpListener httpListener = this._httpServer.getListeners().elementAt(i);
                        httpListener.requestRecieved(httpRequest);
                    }
                    long elapsed = System.currentTimeMillis() - start;
                    HttpServer.WebServerLog.info(String.format("took %.3f seconds to process %s from %s", (double)elapsed / 1000.0, httpRequest.getRequest(), httpConnection.getRemoteAddressString()));
                }
            } else {
                HttpServer.WebServerLog.warn("Missing request");
                this._httpServer.blocklistHostAddress(hostAddress);
                httpConnection.close();
            }
        }
        catch (Exception ex) {
            HttpServer.WebServerLog.error("error during HttpServer.clientConnected()", ex);
        }
    }
}

