/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx;

import com.integpg.dmx.DmxCommandLine;
import com.integpg.janoslib.iolog.DigitalInputsIoLogMonitor;
import com.integpg.janoslib.iolog.DigitalOutputsIoLogMonitor;
import com.integpg.janoslib.iolog.IoChannelEvent;
import com.integpg.janoslib.iolog.IoChannelLogListener;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.logging.Logger;
import com.integpg.janoslib.net.NullClient;
import com.integpg.janoslib.utils.FileUtils;
import com.integpg.janoslib.utils.StringUtils;
import java.io.File;
import java.util.Json;

class TriggerManager {
    private static final TriggerManager INSTANCE = new TriggerManager();
    private static String[][] InputTriggerActions = new String[4][];
    private static String[][] OutputTriggerActions = new String[12][];

    private TriggerManager() {
        DigitalInputsIoLogMonitor inputLogMonitor = new DigitalInputsIoLogMonitor();
        inputLogMonitor.addIoChannelLogEventListener(new IoChannelLogListener(){

            @Override
            public void onIoChannelEvent(IoChannelEvent ioEvent) {
                if (ioEvent.State) {
                    Logger.getLogger("test").info("dmx input trigger");
                    String[] triggerActions = InputTriggerActions[ioEvent.Channel - 1];
                    if (null != triggerActions) {
                        TriggerManager.this.executeTriggerActions(triggerActions);
                    }
                }
            }
        });
        inputLogMonitor.start();
        DigitalOutputsIoLogMonitor outputLogMonitor = new DigitalOutputsIoLogMonitor();
        outputLogMonitor.addIoChannelLogEventListener(new IoChannelLogListener(){

            @Override
            public void onIoChannelEvent(IoChannelEvent ioEvent) {
                String[] triggerActions;
                if (ioEvent.State && null != (triggerActions = OutputTriggerActions[ioEvent.Channel - 1])) {
                    TriggerManager.this.executeTriggerActions(triggerActions);
                }
            }
        });
        outputLogMonitor.start();
    }

    static void load() {
        AppLog.info("Loading Triggers");
        File triggersFile = new File("/flash/dmx/triggers.json");
        if (triggersFile.exists()) {
            try {
                String triggerFileContent = FileUtils.readAllText(triggersFile.getPath());
                Json triggersJson = new Json(triggerFileContent);
                triggersJson = (Json)triggersJson.get("Triggers");
                String[] inputTriggerStrings = (String[])triggersJson.get("InputTriggers");
                System.out.println("inputTriggerStrings: " + inputTriggerStrings);
                for (int i = 0; i < inputTriggerStrings.length; ++i) {
                    String inputTriggerString = inputTriggerStrings[i];
                    if ("".equals(inputTriggerString)) continue;
                    TriggerManager.InputTriggerActions[i] = StringUtils.split(inputTriggerString, ",");
                    System.out.println("inputTriggerString: " + inputTriggerString);
                }
                String[] outputTriggerStrings = (String[])triggersJson.get("OutputTriggers");
                System.out.println("outputTriggerStrings: " + outputTriggerStrings);
                for (int i = 0; i < outputTriggerStrings.length; ++i) {
                    String outputTriggerString = outputTriggerStrings[i];
                    if ("".equals(outputTriggerString)) continue;
                    TriggerManager.OutputTriggerActions[i] = StringUtils.split(outputTriggerString, ",");
                    System.out.println("outputTriggerString: " + outputTriggerString);
                }
            }
            catch (Exception ex) {
                AppLog.error("error loading triggers", ex);
            }
            AppLog.info("Tiggers config loaded");
        }
    }

    public void executeTriggerActions(String[] triggerActions) {
        System.out.println("execute trigger actions");
        if (null != triggerActions) {
            for (String actionString : triggerActions) {
                System.out.println("execute trigger action " + actionString);
                DmxCommandLine.process(NullClient.getInstance(), actionString);
            }
        }
    }
}

