/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx;

import com.integpg.janoslib.debug.Stopwatch;
import com.integpg.system.ArrayUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class WavFile {
    private final String _filename;
    private byte[] _bytes;
    private Stopwatch stopwatch = new Stopwatch("load wav");

    public WavFile(String filename) {
        this._filename = filename;
    }

    public byte[] getBytes() {
        return this._bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFile() {
        this.stopwatch.start();
        File file = new File(this._filename);
        FileInputStream fis = null;
        try {
            if (file.exists()) {
                fis = new FileInputStream(file.getPath());
                DataInputStream dis = new DataInputStream(fis);
                byte[] chunkIdBytes = new byte[4];
                dis.read(chunkIdBytes);
                String chunkIdString = new String(chunkIdBytes);
                System.out.println("chunkIdString: " + chunkIdString);
                if ("RIFF".equals(chunkIdString)) {
                    this.readRiff(dis);
                }
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (null != fis) {
                    fis.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.stopwatch.split("load wav " + file);
        this.stopwatch.stop();
        System.out.println(this.stopwatch.toString());
    }

    public void readRiff(DataInputStream dis) throws IOException {
        int chunkSize = ArrayUtils.swapEndian((int)dis.readInt());
        System.out.println("chunkSize: " + chunkSize);
        byte[] formatBytes = new byte[4];
        dis.read(formatBytes);
        String formatString = new String(formatBytes);
        System.out.println("formatString: " + formatString);
        byte[] subChunkId1Bytes = new byte[4];
        dis.read(subChunkId1Bytes);
        String subChunkId1String = new String(subChunkId1Bytes);
        System.out.println("subChunkId1String: " + subChunkId1String);
        int subChunk1Size = ArrayUtils.swapEndian((int)dis.readInt());
        System.out.println("subChunk1Size: " + subChunk1Size);
        short audioFormat = ArrayUtils.swapEndian((short)dis.readShort());
        System.out.println("audioFormat: " + audioFormat);
        short numChannels = ArrayUtils.swapEndian((short)dis.readShort());
        System.out.println("numChannels: " + numChannels);
        int sampleRate = ArrayUtils.swapEndian((int)dis.readInt());
        System.out.println("sampleRate: " + sampleRate);
        int byteRate = ArrayUtils.swapEndian((int)dis.readInt());
        System.out.println("byteRate: " + byteRate);
        short blockAlign = ArrayUtils.swapEndian((short)dis.readShort());
        System.out.println("blockAlign: " + blockAlign);
        short bitsPerSample = ArrayUtils.swapEndian((short)dis.readShort());
        System.out.println("bitsPerSample: " + bitsPerSample);
        byte[] subChunkId2Bytes = new byte[4];
        dis.read(subChunkId2Bytes);
        String subChunkId2String = new String(subChunkId2Bytes);
        System.out.println("subChunkId2String: " + subChunkId2String);
        int subChunk2Size = ArrayUtils.swapEndian((int)dis.readInt());
        System.out.println("subChunk2Size: " + subChunk2Size);
        this.stopwatch.split("read block header");
        int x = numChannels * bitsPerSample / 8;
        this._bytes = new byte[subChunk2Size];
        dis.read(this._bytes);
        this.stopwatch.split("read block data");
    }
}

