/* global bootbox */

var JnrWebsocket = new JnrWebsocket();

var app = angular.module('DmxApp', []);

var DmxScope;
var DmxController;
app.controller('DmxController', ['$scope', '$compile', function ($scope, $compile) {
    DmxScope = $scope;
    DmxController = this;

    DmxController.FixtureName = getParameterByName("fixtureName");

    DmxController.Channels = [];
    for (var i = 0; i < 512; i++) {
        DmxController.Channels[i] = 0;
    }
    DmxController.FixtureTypes = null;
    DmxController.Fixtures = null;

    DmxController.activateView = function (ele) {
        $compile(ele.contents())($scope);
        $scope.$apply();
    };


    JnrWebsocket.onLoggedIn = function () {
        JnrWebsocket.readFile("/flash/dmx/fixtures/fixture-types.json").then(fixtureFileRead);
        JnrWebsocket.readFile("/flash/dmx/fixtures/fixtures.json").then(fixtureFileRead);

        // ask for the current value for all of the channels
        JnrWebsocket.postMessage(1401, JSON.stringify({
            Command: "get-channel-values"
        }));
    };


    var fixtureFileRead = function (json) {
        var filename = json.File;
        if (filename.endsWith("flash/dmx/fixtures/fixture-types.json")) {
            var fileContent = Base64.decode(json.Data);
            console.log(fileContent);
            var fixtureTypeJson = JSON.parse(fileContent);
            DmxController.FixtureTypes = fixtureTypeJson.FixtureTypes;
            $scope.$apply();
        } else if (filename.endsWith("flash/dmx/fixtures/fixtures.json")) {
            var fileContent = Base64.decode(json.Data);
            console.log(fileContent);
            var fixtureJson = JSON.parse(fileContent);
            DmxController.Fixtures = fixtureJson.Fixtures;

            var fixtureIndex = -1;
            if (null !== DmxController.Fixtures) {
                for (var i = 0; i < DmxController.Fixtures.length; i++) {
                    var fixture = DmxController.Fixtures[i];
                    if (DmxController.FixtureName === fixture.Name) {
                        fixtureIndex = i;
                        break;
                    }
                }
            }

            if (-1 !== fixtureIndex) {
                document.title = fixture.Name;
                $("#fixture").html(DmxController.addChannelsToDialog(fixture, 16));
            }

            $scope.$apply();
        }
    };


    JnrWebsocket.onReplyMessage = function (replyContentJson) {
        var contentJson = JSON.parse(replyContentJson.Content);
        if ("channel-update" === contentJson.Message) {
            var channelsString = contentJson.Channels;
            var channel = contentJson.Min - 1;
            for (var c = 0; c < channelsString.length; c += 2) {
                var channelValue = parseInt(channelsString.substr(c, 2), 16);
                DmxController.Channels[channel++] = channelValue;
            }

        } else {
            var content = replyContentJson.Content;
            var fields = content.split(",");
            var channel = fields[0];
            var value = fields[1];
            DmxController.Channels[channel] = value;
        }

        $scope.$apply();
    };


    DmxController.getFixtureTypeById = function (id) {
        if (null !== DmxController.FixtureTypes) {
            for (var i = 0; i < DmxController.FixtureTypes.length; i++) {
                var fixtureType = DmxController.FixtureTypes[i];
                if (id == fixtureType.Id) {
                    return fixtureType;
                }
            }
        }

    };


    DmxController.addChannelsToDialog = function (fixture, channelsPerColumn) {
        var fixtureType = null;
        if (fixture.FixtureTypeId) {
            fixtureType = DmxController.getFixtureTypeById(fixture.FixtureTypeId);
        }

        var box = document.createElement('div');

        var fixtureNameElement = document.createElement("h3");
        fixtureNameElement.style.paddingLeft = "8px";
        fixtureNameElement.innerHTML = fixture.Name;
        box.appendChild(fixtureNameElement);

        var table = document.createElement('table');
        box.appendChild(table);

        var trElement = document.createElement("tr");
        table.appendChild(trElement);

        for (var i = 0; i <= Math.floor((fixtureType.ChannelCount - 1) / channelsPerColumn); i++) {
            var tdElement = document.createElement("td");
            tdElement.style.verticalAlign = 'top';
            tdElement.style.paddingLeft = "8px";
            trElement.appendChild(tdElement);

            //            for (var channelIndex = fixture.StartChannel; channelIndex < fixture.StartChannel + fixtureType.ChannelCount; channelIndex++) {
            var startChannel = i * channelsPerColumn + 1;
            var endChannel = (i + 1) * channelsPerColumn;
            if (endChannel > fixtureType.ChannelCount)
                endChannel = (i * channelsPerColumn) + (fixtureType.ChannelCount % channelsPerColumn);

            for (var j = startChannel; j <= endChannel; j++) {
                DmxController.addChannelToDialog(tdElement, fixture, fixture.StartChannel + j - 1);
            }
        }

        //            for (var channelIndex = fixture.StartChannel; channelIndex < fixture.StartChannel + fixtureType.ChannelCount; channelIndex++) {
        //                DmxController.addChannelToDialog(box, fixture, channelIndex);
        //            }
        return box;
    };

    //        var _waterfall;


    DmxController.addChannelToDialog = function (parentFaderBank, fixture, channel) {
        var fixtureType = null;
        if (fixture.FixtureTypeId) {
            fixtureType = DmxController.getFixtureTypeById(fixture.FixtureTypeId);
        }
        var channelIndex = channel - fixture.StartChannel;

        var label = "Channel " + channel;
        if (fixtureType.ChannelNames && fixtureType.ChannelNames[channelIndex] && null !== fixtureType.ChannelNames[channelIndex]) {
            label = fixtureType.ChannelNames[channelIndex];
        }

        var channelElement = document.createElement("div");
        channelElement.className = "channel";
        parentFaderBank.appendChild(channelElement);

        var channelLabel = document.createElement("div");
        channelLabel.className = "channel-label";
        channelLabel.innerHTML = label;
        channelLabel.style.color = "#fff";
        channelElement.appendChild(channelLabel);

        var channelSliderElement = document.createElement("div");
        channelSliderElement.className = "channel-slider";
        channelElement.appendChild(channelSliderElement);

        var channelSlider = document.createElement("input");
        channelSlider.id = channel;
        channelSlider.setAttribute("type", "range");
        channelSlider.setAttribute("value", "0");
        channelSlider.setAttribute("min", "0");
        channelSlider.setAttribute("max", "255");
        channelSlider.setAttribute("ng-model", "dmx.Channels[" + (channel - 1) + "]");
        channelSlider.setAttribute("value", "{{dmx.Channels[" + (channel - 1) + "]}}");
        channelSlider.addEventListener("input", function (event) {
            DmxController.slide(event);
        });
        channelSlider.addEventListener("change", function (event) {
            DmxController.slide(event);
        });
        channelSliderElement.appendChild(channelSlider);

        var channelValue = document.createElement("input");
        //            channelValue.className = "channel-value";
        //            channelValue.setAttribute("ng-model", "dmx.Channels[" + (channel - 1) + "]");
        //            channelValue.setAttribute("ng-bind", "dmx.Channels[" + (channel - 1) + "]");
        channelValue.setAttribute("value", "{{dmx.Channels[" + (channel - 1) + "]}}");
        channelValue.style.width = "50px";
        channelValue.style.background = "#ccc";
        channelValue.style.marginLeft = "8px";
        channelValue.onfocusout = function () {
            console.log("channelValue.onfocusout");
            event.target.id = channel;
            DmxController.slide(event);
        };
        channelValue.onkeypress = function (e) {
            if (e.keyCode === 13) {
                console.log("channelValue.onkeypress: ENTER");
                event.target.id = channel;
                DmxController.slide(event);
            } else {
                var charCode = (event.which) ? event.which : event.keyCode;
                if (!(48 <= charCode && 57 >= charCode)) {
                    event.preventDefault(); //stop character from entering input
                    //                        return false;
                } else {
                    var val = event.target.value;
                    var newVal = val.substring(0, event.target.selectionStart);
                    newVal += event.key;
                    newVal += val.substring(event.target.selectionEnd);
                    if (parseInt(newVal) > 255) {
                        event.preventDefault(); //stop character from entering input
                    }
                }
            }
        };
        channelElement.appendChild(channelValue);

        DmxController.activateView(angular.element(channelElement));
    };


    DmxController.slide = function (evt) {
        var val = evt.target.value;
        var channel = evt.target.id;

        //            var parent = document.getElementById(channel).parentElement.parentElement;
        //            var channelValue = parent.getElementsByClassName("channel-value")[0];
        //            channelValue.innerHTML = val;

        //        if (JnrWebsocket.open) {
        //            var request = new Object();
        //            request['Message'] = "Post Message";
        //            request['Number'] = 1400;
        //            request['Content'] = channel + "," + val;
        //            JnrWebsocket.sendJson(request);

        JnrWebsocket.postMessage(1400, channel + "," + val);
        //        }
    };


    DmxController.executeScript = function (script) {
        //            DmxController.ExecuteDialog = bootbox.confirm({
        //                title: "Execute " + script.Name,
        //                message: "How many times should <B>" + script + "</b> repeat? <input type'number' id='repeat-count' class='form-control' value='1'>",
        //                buttons: {
        //                    cancel: {
        //                        label: 'Cancel',
        //                        className: 'btn-default'
        //                    },
        //                    confirm: {
        //                        label: 'Execute',
        //                        className: 'btn-success'
        //                    }
        //                },
        //                callback: function (result) {
        //                    if (result) {
        JnrWebsocket.postMessage(1401, JSON.stringify({
            Command: "exec-script",
            ScriptName: script,
            RepeatCount: 1 //$("#repeat-count").val()
        }));
        //                    }
        //                }
        //            });
        //            DmxController.ExecuteDialog.init(function () {
        //                $(".modal-header").css("background-color", "#5cb85c");
        //                $(".modal-header").css("color", "#fff");
        //                $("#repeat-count").focus();
        //            });
    };


    JnrWebsocket.connect();
    //        JnrWebsocket.initPing(1401);
}
]);




function getParameterByName(name) {
    var url = window.location.href;
    name = name.replace(/[\[\]]/g, "\\$&");
    var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
        results = regex.exec(url);
    if (!results)
        return null;
    if (!results[2])
        return '';
    return decodeURIComponent(results[2].replace(/\+/g, " "));
}